/*
 * graph2D
 * Copyright (c) 2009 Shun Moriya <shun126@users.sourceforge.jp>
 *
 * This software is provided 'as-is', without any express or implied
 * warranty. In no event will the authors be held liable for any damages
 * arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 *  1. The origin of this software must not be misrepresented; you must not
 *     claim that you wrote the original software. If you use this software
 *     in a product, an acknowledgment in the product documentation would be
 *     appreciated but is not required.
 *
 *  2. Altered source versions must be plainly marked as such, and must not be
 *     misrepresented as being the original software.
 *
 *  3. This notice may not be removed or altered from any source
 *     distribution.
 */

#define INCLUDE_FROM_OBJC_C
#include "audioPlayer_impl.h"
#include "data_impl.h"
#import <AVFoundation/AVFoundation.h>

namespace Graph2D
{
	namespace Implementation
	{
		namespace AudioPlayer
		{
			void* play(const std::string& filename)
			{
				NSString* pathName = [NSString stringWithUTF8String:filename.c_str()];
				NSURL* resourceURL = [DataController getResouceUriWithString:pathName];
				assert(resourceURL);

				AVAudioPlayer* track = [[AVAudioPlayer alloc] initWithContentsOfURL:resourceURL error:nil];
				if(track == nil)
					return NULL;

				if(![track play])
				{
					[track release];
					return NULL;
				}

				return track;
			}

			void pause(void* self, const bool on)
			{
				AVAudioPlayer* player = reinterpret_cast<AVAudioPlayer*>(self);
				if(on)
					[player pause];
				else
					[player play];
			}

			void stop(void* self)
			{
				AVAudioPlayer* player = reinterpret_cast<AVAudioPlayer*>(self);
				[player stop];
			}

			void release(void* self)
			{
				AVAudioPlayer* player = reinterpret_cast<AVAudioPlayer*>(self);
				[player stop];
				[player release];
			}

			bool playing(void* self)
			{
				AVAudioPlayer* player = reinterpret_cast<AVAudioPlayer*>(self);
				return player.playing;
			}

			float addVolume(void* self, const float offset)
			{
				AVAudioPlayer* player = reinterpret_cast<AVAudioPlayer*>(self);
				player.volume += offset;
				return player.volume;
			}

			float getVolume(void* self)
			{
				AVAudioPlayer* player = reinterpret_cast<AVAudioPlayer*>(self);
				return player.volume;
			}

			void setVolume(void* self, const float vol)
			{
				AVAudioPlayer* player = reinterpret_cast<AVAudioPlayer*>(self);
				player.volume = vol;
			}

			void setLoopCount(void* self, const int numberOfLoops)
			{
				AVAudioPlayer* player = reinterpret_cast<AVAudioPlayer*>(self);
				player.numberOfLoops = numberOfLoops;
			}

			double getCurrentTime(void* self)
			{
				AVAudioPlayer* player = reinterpret_cast<AVAudioPlayer*>(self);
				NSTimeInterval timeInterval = player.currentTime;
				return static_cast<double>(timeInterval);
			}

			void setCurrentTime(void* self, const double second)
			{
				AVAudioPlayer* player = reinterpret_cast<AVAudioPlayer*>(self);
				player.currentTime = static_cast<NSTimeInterval>(second);
			}
		}
	}
}
