/*
 * graph2D
 * Copyright (c) 2009 Shun Moriya <shun126@users.sourceforge.jp>
 *
 * This software is provided 'as-is', without any express or implied
 * warranty. In no event will the authors be held liable for any damages
 * arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 *  1. The origin of this software must not be misrepresented; you must not
 *     claim that you wrote the original software. If you use this software
 *     in a product, an acknowledgment in the product documentation would be
 *     appreciated but is not required.
 *
 *  2. Altered source versions must be plainly marked as such, and must not be
 *     misrepresented as being the original software.
 *
 *  3. This notice may not be removed or altered from any source
 *     distribution.
 */

#if !defined(___GRAPH2D_PARTICLE_H___)
#define ___GRAPH2D_PARTICLE_H___

#include "component.h"

namespace Graph2D
{
	class Particle : public Component
	{
		DISALLOW_COPY_AND_ASSIGN(Particle);

		typedef Component super;
		friend class ParticleManager;

		Vector2 gravity;
		Vector2 velocity;
		float life;
		Particle* next;
		unsigned short index;

	protected:
		virtual ~Particle()
		{
		}

	public:
		Particle()
		{
			next = NULL;
			gravity.y = 9.8f;
			//velocity;
			life = 0.f;
		}

		Particle* getNext() const
		{
			return next;
		}

		unsigned short getIndex() const
		{
			return index;
		}

		void setIndex(const unsigned short index)
		{
			this->index = index;
		}

		void setNext(Particle* particle)
		{
			next = particle;
		}

		const Vector2& getGravity() const
		{
			return gravity;
		}

		void setGravity(const Vector2& gravity)
		{
			this->gravity = gravity;
		}

		const Vector2& getVelocity() const
		{
			return velocity;
		}

		void setVelocity(const Vector2& velocity)
		{
			this->velocity = velocity;
		}

		float getLife() const
		{
			return life;
		}

		void setLife(const float life)
		{
			this->life = life;
		}

		virtual void onUpdate(const UpdateInfomation& updateInfomation);
		virtual void onDraw(const DrawRect& drawRect);
	};
}

#endif
