/*
 * graph2D
 * Copyright (c) 2011 Shun Moriya <shun126@users.sourceforge.jp>
 *
 * This software is provided 'as-is', without any express or implied
 * warranty. In no event will the authors be held liable for any damages
 * arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 *  1. The origin of this software must not be misrepresented; you must not
 *     claim that you wrote the original software. If you use this software
 *     in a product, an acknowledgment in the product documentation would be
 *     appreciated but is not required.
 *
 *  2. Altered source versions must be plainly marked as such, and must not be
 *     misrepresented as being the original software.
 *
 *  3. This notice may not be removed or altered from any source
 *     distribution.
 */

#include "messageTranslater.h"
#include <map>

namespace Graph2D
{
	namespace MessageTranslater
	{
		std::map<std::string, std::string> dictonary;	// not serialized !!!

		void clearDictonary()
		{
			dictonary.clear();
		}

		void addWord(const char* key, const char* word)
		{
			eraseWord(key);

			dictonary.insert(std::pair<std::string, std::string>(key, word));
		}

		void eraseWord(const char* key)
		{
			std::map<std::string, std::string>::iterator i = dictonary.find(key);
			if(i != dictonary.end())
			{
				dictonary.erase(i);
			}
		}

		void translate(std::string& text)
		{
			for(std::map<std::string, std::string>::iterator i = dictonary.begin(); i != dictonary.end(); i++)
			{
				const size_t length = (*i).first.size();
				
				int position = 0;
				while((position = text.find((*i).first, position)) != std::string::npos)
				{
					text.replace(position, length, (*i).second);
				}
			}
		}
	}
}
