/*
 * graph2D
 * Copyright (c) 2009 Shun Moriya <shun126@users.sourceforge.jp>
 *
 * This software is provided 'as-is', without any express or implied
 * warranty. In no event will the authors be held liable for any damages
 * arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 *  1. The origin of this software must not be misrepresented; you must not
 *     claim that you wrote the original software. If you use this software
 *     in a product, an acknowledgment in the product documentation would be
 *     appreciated but is not required.
 *
 *  2. Altered source versions must be plainly marked as such, and must not be
 *     misrepresented as being the original software.
 *
 *  3. This notice may not be removed or altered from any source
 *     distribution.
 */

#if !defined(___GRAPHC2D_MENU_H___)
#define ___GRAPHC2D_MENU_H___

#include "imageButton.h"
#include "text.h"
#include "window.h"

namespace Graph2D
{
	class Menu : public Window, public ActionEvent, public ClickEvent
	{
		DISALLOW_COPY_AND_ASSIGN(Menu);

		typedef Window super;

		typedef enum Layer
		{
			LAYER_CLOSE_BUTTON = 0,
			LAYER_CAPTION,
			LAYER_CONTAINER,
			LAYER_SIZE
		}Layer;

		unsigned short padding;
		bool dirty;

	protected:
		virtual ~Menu();

	public:
		Menu();

		virtual const char* getTypeName() const
		{
			return "Menu";
		}

		Text* getCaption();
		void setCaption(Text* caption);
		void setCaption(const std::string& caption);

		ImageButton* getCloseButton();
		void setCloseButton(ImageButton* button);

		Container* getContainer();
		void setContainer(Container* container);

		void addContents(Component* component, const int data);
		void addContents(const std::string& text, const int data);
		Component* searchContents(const int data);
		void clearContents();

		unsigned short getPadding() const;
		void setPadding(const unsigned short padding);

		void adjust();
		
		virtual void onSerialize(mana_stream* stream) const;
		virtual void onDeserialize(mana_stream* stream);

#if defined(DEBUG) || defined(_DEBUG) || defined(_DEBUG_) || !defined(NDEBUG)
		virtual void onUpdate(const UpdateInfomation& updateInfomation)
		{
			super::onUpdate(updateInfomation);
		}
#endif
		virtual void onDraw(const DrawRect& drawRect);
#if 0
		virtual bool onTouchesBegan(const Vector2& localPosition);
		virtual bool onTouchesEnded(const Vector2& localPosition);
		virtual bool onTouchesCancelled(const Vector2& localPosition);
#endif
		virtual void onAction(Component* component, const unsigned int identification);
		virtual void onClick(Component* component);
		virtual void onCloseButtonDown();

		virtual bool compare(const Menu& other) const;
	};
}

#endif
