/*
 * graph2D
 * Copyright (c) 2009 Shun Moriya <shun126@users.sourceforge.jp>
 *
 * This software is provided 'as-is', without any express or implied
 * warranty. In no event will the authors be held liable for any damages
 * arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 *  1. The origin of this software must not be misrepresented; you must not
 *     claim that you wrote the original software. If you use this software
 *     in a product, an acknowledgment in the product documentation would be
 *     appreciated but is not required.
 *
 *  2. Altered source versions must be plainly marked as such, and must not be
 *     misrepresented as being the original software.
 *
 *  3. This notice may not be removed or altered from any source
 *     distribution.
 */

#if !defined(___GRAPH2D_IMAGE_BUTTON_H___)
#define ___GRAPH2D_IMAGE_BUTTON_H___

#include "container.h"
#include <string>

namespace Graph2D
{
	class ImageButton : public Component
	{
		DISALLOW_COPY_AND_ASSIGN(ImageButton);

		typedef Component super;

	public:
		typedef enum Layout
		{
			LAYOUT_CENTER = 0,
			LAYOUT_LEFT,
			LAYOUT_RIGHT,
		}Layout;

	private:
		Texture* frameTexture[3][2];
		Vector2 frameTexCoord[3][2];
		float leftFrameSize;
		float rightFrameSize;
		ClickEvent* clickEvent;

	protected:
		static const int BUTTON_MARGIN_X = (3);
		static const int BUTTON_MARGIN_Y = (3);
		static const int BUTTON_PUSHED_MARGIN_X = (BUTTON_MARGIN_X / 2);
		static const int BUTTON_PUSHED_MARGIN_Y = (BUTTON_MARGIN_Y / 2);
		static const int BUTTON_MARGIN_SIZE_X = (BUTTON_MARGIN_X * 2);
		static const int BUTTON_MARGIN_SIZE_Y = (BUTTON_MARGIN_Y * 2);

		virtual ~ImageButton(){}

	public:
		ImageButton();

		virtual const char* getTypeName() const
		{
			return "ImageButton";
		}

		bool loadFrameTexture(const Layout direction, const std::string& filename, const bool pushed);
		void unloadFrameTexture(const Layout direction, const bool pushed);

		const Vector2& getFrameTexCoord(const Layout direction, const bool pushed) const;
		void setFrameTexCoord(const Layout direction, const Vector2& frameTexCoord, const bool pushed);
		void setFrameTexCoord(const Layout direction, const float u, const float v, const bool pushed);

		//! 四隅フレームテクスチャサイズ
		float getLeftFrameSize() const
		{
			return leftFrameSize;
		}

		void setLeftFrameSize(const float size)
		{
			leftFrameSize = size;
		}

		float getRightFrameSize() const
		{
			return rightFrameSize;
		}

		void setRightFrameSize(const float size)
		{
			rightFrameSize = size;
		}

		void setClickEvent(ClickEvent* clickEvent)
		{
			this->clickEvent = clickEvent;
		}

		virtual void onSerialize(mana_stream* stream) const;
		virtual void onDeserialize(mana_stream* stream);
		virtual void onDraw(const DrawRect& drawRect);
		virtual bool onTouchesBegan(const Vector2& localPosition);
		virtual bool onTouchesEnded(const Vector2& localPosition);
		virtual bool onTouchesCancelled(const Vector2& localPosition);

		virtual bool compare(const ImageButton& other) const;

	private:
		void drawFrame(Texture* texture, const Vector2& uv, const Vector2& v0, const Vector2& v1, const Vector2& v2, const Vector2& v3, const Color& color, const float width, const float height);
	};
}

#endif
