/*
 * graph2D
 * Copyright (c) 2009 Shun Moriya <shun126@users.sourceforge.jp>
 *
 * This software is provided 'as-is', without any express or implied
 * warranty. In no event will the authors be held liable for any damages
 * arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 *  1. The origin of this software must not be misrepresented; you must not
 *     claim that you wrote the original software. If you use this software
 *     in a product, an acknowledgment in the product documentation would be
 *     appreciated but is not required.
 *
 *  2. Altered source versions must be plainly marked as such, and must not be
 *     misrepresented as being the original software.
 *
 *  3. This notice may not be removed or altered from any source
 *     distribution.
 */

#if !defined(___GRAPH2D_AUDIO_PLAYER_H___)
#define ___GRAPH2D_AUDIO_PLAYER_H___

#include "common.h"
#include "abort.h"
#include <string>

namespace Graph2D
{
	class AudioPlayer
	{
#if defined(TARGET_IPHONE)
		static const int AUDIO_PLAYER_MAX_TRACK = 2;
#else
		static const int AUDIO_PLAYER_MAX_TRACK = 3;
#endif
		typedef struct Environment
		{
			std::string filename;
			void* player;
			float deltaVolume;				//!< tF[h
			float targetVolume;				//!< tF[hړIF
			float timeVolume;				//!< tF[h
			unsigned char flag;
			unsigned char pad[3];
		}Environment;

		Environment tracks[AUDIO_PLAYER_MAX_TRACK];

		AudioPlayer();
		~AudioPlayer();

		Environment* find(const std::string filename);

	public:
		static AudioPlayer& getInstance();

		int talk(const std::string& filename);
		int play(const std::string& filename, const float value, const float second);
		void pause(const int track, const bool on, const float second);
		void stop(const int track, const float second);
		void volume(const int track, const float value, const float second);

		const std::string& getFilename(const int track) const;

		bool isPlaying(const int track) const;

		double getCurrentTime(const int track) const;
		void setCurrentTime(const int track, const double second);

		void onUpdate(const float deltaTime);
	};
}

#endif
