#include"../../Maid/FrameWork/Windows/CSingleWindowAppWindows.h"

#include"../../Maid/Graphic/CGraphic.h"
#include"../../Maid/Graphic/CModelFile.h"

#include"../../Maid/Storage/CStorage.h"

#include"../../Maid/Auxiliary/CString.h"


#include"../../Maid/Input/CMouse.h"
#include"../../Maid/Input/CKeybord.h"

#include"../../Maid/template/counter.h"
using namespace Maid;



class CApp : public IGameThread
{
protected:
	void OnLocalSetup( APPCONFIG& conf )
	{

	}

	void OnLocalEnd()
	{

	}

	void OnLocalBegin( const BEGINPARAM& param )
	{
		{
			CGraphic::SCREENMODE m;

			m.Mode = CGraphic::SCREENMODE::TYPE_WINDOW;
			m.Size = SIZE2DI(800,600);
			m.RefreshRate = 0;
			m.IsSoftTnL = false;
			m.IsWaitVSync = true;
			m.IsAspectLock = false;

			m_Graphic.Initialize( m, param.pFontDriver, param.pInfo );
		}

		m_Mouse.Initialize( param.pMouseDriver );
		m_Keybord.Initialize( param.pKeybordDriver, param.pCharCodeDriver );
		m_Storage.Initialize( );


		model.Load( MAIDTEXT("ball_tone.lwo") );
		shadow.Load( MAIDTEXT("ball_tone_shadow.bmp") );

		while( true )
		{
			if( model.IsNowLoading() ) { ::Sleep(100); continue; }
			break;
		}
		while( true )
		{
			if( shadow.IsNowLoading() ) { ::Sleep(100); continue; }
			break;
		}


		rot.Set( DEGtoRAD(0), DEGtoRAD(360), 100 );
		light_rot.Set( DEGtoRAD(0), DEGtoRAD(360), 200 );

	}

	void OnLocalLoop()
	{
		m_Mouse.Update();
		m_Keybord.Update();

		CCamera camera;

		camera.SetPerspective( DEGtoRAD(60), 800.0f/600.0f, 0.1f, 100.0f ); 
		camera.SetPosition( POINT3DF( 0,0,-5) ); 
		camera.SetTarget( POINT3DF( 0,0,0) );
		camera.SetUpVector( VECTOR3DF(0,1,0) );


		CGraphic::LIGHT Light;
		Light.Direction = VECTOR3DF(-1.0f,0.0f,0.0f);

		++rot;
		++light_rot;

		Light.Direction.x = Math<float>::cos(light_rot);
		Light.Direction.y = 0;
		Light.Direction.z = Math<float>::sin(light_rot);




		//	ŕ`施߂o
		m_Graphic.ClearRenderTargetColor( COLOR_A08R08G08B08I(0xFF,0x00,0x00,0x80) );
		m_Graphic.ClearRenderTargetZ( 1.0f );


		m_Graphic.SetCamera( camera );

		m_Graphic.BltModelToneSR( model, shadow, Light, 5, POINT3DF(0,0,0), SIZE3DF(1.5f,1.5f,1.5f), rot, VECTOR3DF(0,1,0) );



		{	//	eLXg̕\
			char* buf = 
				"eXg"
				;


			SPFONT pFont = m_Graphic.CreateFont( 0, SIZE2DI(16,32), true, false, false );
			m_Graphic.BltText( POINT2DF(0,0), pFont, COLOR_A08R08G08B08I(0xFF,0xFF,0xFF,0xFF), CString::ConvertSJIStoMAID(buf) );
		}

		//	̃t[
		OnNextFrame(m_Graphic);
		::Sleep(10);
	}
private:
	CGraphic	m_Graphic;
	CStorage	m_Storage;
	CMouse		m_Mouse;
	CKeybord	m_Keybord;

	CModelFile model;
	CTextureFile shadow;

	CLoopCounter<float> rot;
	CLoopCounter<float> light_rot;


};


int WINAPI WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow )
{
	CSingleWindowAppWindows capp( SPGAMETHREAD( new CApp ) );
	return capp.Run( hInstance, hPrevInstance, lpCmdLine, nCmdShow );
}