#include"../../Maid/FrameWork/Windows/CSingleWindowAppWindows.h"

#include"../../Maid/Graphic/CGraphic.h"
#include"../../Maid/Storage/CStorage.h"

#include"../../Maid/Sound/CSound.h"
#include"../../Maid/Sound/CSoundObject.h"

#include"../../Maid/Auxiliary/CString.h"


#include"../../Maid/Input/CMouse.h"
#include"../../Maid/Input/CKeybord.h"

using namespace Maid;



class CApp : public IGameThread
{
protected:
	void OnLocalSetup( APPCONFIG& conf )
	{

	}

	void OnLocalEnd()
	{

	}

	void OnLocalBegin( const BEGINPARAM& param )
	{
		{
			CGraphic::SCREENMODE m;

			m.Mode = CGraphic::SCREENMODE::TYPE_WINDOW;
			m.Size = SIZE2DI(800,600);
			m.RefreshRate = 0;
			m.IsSoftTnL = false;
			m.IsWaitVSync = true;
			m.IsAspectLock = false;

			m_Graphic.Initialize( m, param.pFontDriver, param.pInfo );
		}


		{
			m_Sound.Initialize();
		}
		{
			m_Storage.Initialize( );
		}
		{
			m_Mouse.Initialize( param.pMouseDriver );
			m_Keybord.Initialize( param.pKeybordDriver, param.pCharCodeDriver );
		}



		obj1.Load( CSoundObject::TYPE_SE, MAIDTEXT("se001.wav") );
		obj2.Load( CSoundObject::TYPE_BGM, MAIDTEXT("LoopStream.ogg"), true );

		//	ǂݍ݂I܂ő҂
		while( true )
		{
			if( obj1.IsNowLoading() ) { ::Sleep(100); continue; }
			break;
		}

		while( true )
		{
			if( obj2.IsNowLoading() ) { ::Sleep(100); continue; }
			break;
		}
	}

	void OnLocalLoop()
	{
		//	}EX̍XV
		m_Mouse.Update();

		//	L[{[h̍XV
		m_Keybord.Update();



		if( m_Keybord.IsIn('A') )
		{
			obj1.Play();
		}

		if( m_Keybord.IsIn('B') )
		{
			obj1.Play(3);
		}

		if( m_Keybord.IsIn('C') )
		{
			obj2.Play(CSoundObject::PLAY_LOOP);
		}

		if( m_Keybord.IsIn('D') )
		{
			obj2.Stop();
		}
		if( m_Keybord.IsIn('E') )
		{
			obj2.Resume();
		}

		if( m_Keybord.IsIn(CKeybord::BUTTON_NUM1) )
		{
			obj1.SetVolume( obj1.GetVolume()-100, 0 );
		}
		if( m_Keybord.IsIn(CKeybord::BUTTON_NUM2) )
		{
			obj1.SetVolume( obj1.GetVolume()+100, 0 );
		}

		if( m_Keybord.IsIn(CKeybord::BUTTON_NUM3) )
		{
			obj2.FadeOut( 1000 );
		}
		if( m_Keybord.IsIn(CKeybord::BUTTON_NUM4) )
		{
			obj2.FadeIn( 1000 );
		}

		if( m_Keybord.IsIn(CKeybord::BUTTON_NUM5) )
		{
			m_Sound.SetGlobalVolume( m_Sound.GetGlobalVolume()-100 );
		}
		if( m_Keybord.IsIn(CKeybord::BUTTON_NUM6) )
		{
			m_Sound.SetGlobalVolume( m_Sound.GetGlobalVolume()+100 );
		}

		if( m_Keybord.IsIn(CKeybord::BUTTON_TEN1) )
		{
			m_Sound.SetVolume( 0, m_Sound.GetVolume(0)-100 );
		}
		if( m_Keybord.IsIn(CKeybord::BUTTON_TEN2) )
		{
			m_Sound.SetVolume( 0, m_Sound.GetVolume(0)+100 );
		}
		if( m_Keybord.IsIn(CKeybord::BUTTON_TEN4) )
		{
			m_Sound.SetVolume( 1, m_Sound.GetVolume(1)-100 );
		}
		if( m_Keybord.IsIn(CKeybord::BUTTON_TEN5) )
		{
			m_Sound.SetVolume( 1, m_Sound.GetVolume(1)+100 );
		}

		//	ŕ`施߂o
		m_Graphic.ClearRenderTargetColor( COLOR_A08R08G08B08I(0xFF,0x00,0x00,0x80) );

		{	//	eLXg̕\
			char* buf = 
				"A:SEPĐ\n"
				"B:SERĐ\n"
				"C:BGM[vĐ\n"
				"D:BGM~\n"
				"E:BGMĐĊJ\n"
				"1or2:PSE{[㉺ %d\n"
				"3or4:PBGM{[tF[hAEgEC %d\n"
				"5or6:S̃{[㉺ %d\n"
				"ten1or2:Ŝrd{[㉺ %d\n"
				"ten4or5:Ŝafl{[㉺ %d\n"
				;

			char text[512];
			sprintf( text, buf, obj1.GetVolume(), obj2.GetVolume(),
				m_Sound.GetGlobalVolume(), m_Sound.GetVolume(0),  m_Sound.GetVolume(1) );

			SPFONT pFont = m_Graphic.CreateFont( 0, SIZE2DI(16,32), true, false, false );
			m_Graphic.BltText( POINT2DF(0,0), pFont, COLOR_A08R08G08B08I(0xFF,0xFF,0xFF,0xFF), CString::ConvertSJIStoMAID(text) );
		}

		//	̃t[
		OnNextFrame(m_Graphic);
		::Sleep(10);
	}


private:
	CGraphic	m_Graphic;
	CStorage	m_Storage;
	CSound		m_Sound;
	CMouse		m_Mouse;
	CKeybord	m_Keybord;

	CSoundObject obj1;
	CSoundObject obj2;

};


int WINAPI WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow )
{
	CSingleWindowAppWindows capp( SPGAMETHREAD( new CApp ) );
	return capp.Run( hInstance, hPrevInstance, lpCmdLine, nCmdShow );
}