/*!
 *	\file
 *	\brief	CXg[sNX
 *
 */


#ifndef Install_h
#define Install_h

#include"../../Maid/Auxiliary/Thread/CThreadController.h"
#include"../../Maid/Auxiliary/Thread/CThreadMutex.h"
#include"CSetupConfig.h"
#include<boost/function.hpp>
#include<string>


class Install
{
public:


	struct INSTALLDATA
	{
		const CSetupConfig*	pConfig;
		int					InstallTypeNo;		//	CXg[[h
		HWND				hWnd;				//	EBhEnhiG[NƂȂǂɎgpj
		bool				IsMD5Check;			//	CXg[MD5`FbN邩H
	};

	void BeginInstall( const INSTALLDATA& InstallData );

	struct STATUS
	{
		enum THREADSTATUS
		{
			THREADSTATUS_EXECUTING,	//!<	s
			THREADSTATUS_ERROR,		//!<	G[N
			THREADSTATUS_SUCCESS,		//!<	ďI
			THREADSTATUS_CANCEL,		//!<	LZ߂łďI
		};

		THREADSTATUS	Status;

		Maid::mstring ProgressText;
		float NowProgress;
		float TotalProgress;
	};

	STATUS GetStatus();
	void   OnCancel();

private:
	unt32		InstallThread( volatile Maid::CThreadController::BRIGEDATA& Brige );

private:
	void InstallCancel();
	void InstallError( const Maid::mstring& comment );

	enum FUNCTIONRESULT
	{
		FUNCTIONRESULT_OK,
		FUNCTIONRESULT_CANCEL,
		FUNCTIONRESULT_ERROR,
	};

	FUNCTIONRESULT	FileCopy( const Maid::mstring& DstFileName,  const Maid::mstring& SrcFileName, volatile Maid::CThreadController::BRIGEDATA& Brige );
	FUNCTIONRESULT	CheckMD5( const Maid::mstring& DstFileName, const Maid::mstring& MD5Str, volatile Maid::CThreadController::BRIGEDATA& Brige );

	void	SetProgressText( const Maid::mstring& );
	void	SetNowProgress( float );
	void	SetTotalProgress( float );

private:
	INSTALLDATA	m_InstallData;

private:
	Maid::CThreadMutex	m_Section;
	Maid::CThreadController	m_Thread;

	STATUS	m_NowState;


	struct ExecutingInfo	//	CXg[sɎQƂ
	{
		float	TotalFileSize;	//	CXg[鍇ve//	4G𒴂邱Ƃ̂float^ɂĂ
		float	AccessFileSize;	//	܂܂łɏ(ǂݍ)TCY

		MySTL::vector<Maid::mstring> CreateDirectoryList;
	};

	ExecutingInfo	m_ExecutingInfo;
};

#endif

