#include"Install.h"
#include"../../Maid/Auxiliary/XML/CXMLWriter.h"
#include"../../Maid/Auxiliary/FileIO/CFileRead.h"
#include"../../Maid/Auxiliary/FileIO/CFileWrite.h"
#include"../../Maid/Auxiliary/Windows/CShell.h"
#include"../../Maid/Auxiliary/Windows/CRegistry.h"
#include"../../Maid/Auxiliary/CString.h"
#include"resource.h"
#include<io.h>
#include<direct.h>
#include<set>
#include"md5.h"
#include"../MaidUninstaller/SetupGlobal.h"

using namespace Maid;

/*!
 *	\class	Install Install.h
 *	\brief	CXg[sNX
\n			CXg[͕̂ʃXbhōsĂ̂ŁACXbh펞Ď`ɂȂ܂
 */

static const unt32 COPY_PACET = 1024*256;	//	̃Rs[Ŏst@CTCY
static const unt32 MD5CHECKSIZE = 1024*256;	//	̃Rs[Ŏst@CTCY
static unt08 COPYBUF[COPY_PACET];		//	pPbgRs[ňꎞIɎgobt@
										//	MD5 ̃`FbNɂg






/*	S̏̐i݋̖ڈ

	ECXg[ݒ̍쐬(00%-05%)
	Et@C̃Rs[      (05%-90%)
	EACXg[ݒ  (90%-95%)
	EWXg̏  (95%-100%)
*/
static const int TOTALPROGRESS_SETUPBEGIN = 0;
static const int TOTALPROGRESS_SETUPEND   = 5;
static const int TOTALPROGRESS_FILECOPYBEGIN  = TOTALPROGRESS_SETUPEND;
static const int TOTALPROGRESS_FILECOPYEND    = 90;
static const int TOTALPROGRESS_SHORTCUTBEGIN = TOTALPROGRESS_FILECOPYEND;
static const int TOTALPROGRESS_SHORTCUTEND   = 93;
static const int TOTALPROGRESS_REGISTORYBEGIN = TOTALPROGRESS_SHORTCUTBEGIN;
static const int TOTALPROGRESS_REGISTORYEND   = 96;
static const int TOTALPROGRESS_UNINSTALLBEGIN = TOTALPROGRESS_REGISTORYBEGIN;
static const int TOTALPROGRESS_UNINSTALLEND   = 100;

static const int TOTALPROGRESS_FINAL = TOTALPROGRESS_UNINSTALLEND;


float PER( int p )
{
	return float(p)/float(TOTALPROGRESS_FINAL);
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! CXg[̊Jn
/*!
 *	̊֐ GetStatus() ŏԂ 
\n	STATE_SUCCESS	ƐI
\n	STATE_ERROR		ƎsďI
 *
 *	\param	InstallData	[i ]	CXg[ݒ
 *
 *	\return CXg[Jn DENRESULT_OK
\n			Ȃ DENRESULT_OK ȊO
 */
void Install::BeginInstall( const Install::INSTALLDATA& InstallData )
{
	m_NowState.Status = STATUS::THREADSTATUS_EXECUTING;

	m_InstallData = InstallData;

	m_Thread.SetFunc( MakeThreadObject( &Install::InstallThread, this) );
	m_Thread.Execute();
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ݂̏Ԃ擾
/*!
 *	BeginInstall() Ă邱
 *
 *	\return ݂̃CXg[
\n			ڂ̓wb_Q
 */
Install::STATUS Install::GetStatus()
{
	STATUS s;
	{
		CThreadMutexLocker Lock(m_Section);

		s = m_NowState;
	}

	return s;
}


void	Install::SetProgressText( const mstring& tex )
{
	CThreadMutexLocker Lock(m_Section);
	m_NowState.ProgressText = tex;
}

void	Install::SetNowProgress( float v )
{
	CThreadMutexLocker Lock(m_Section);
	m_NowState.NowProgress = v;
}

void	Install::SetTotalProgress( float v )
{
	CThreadMutexLocker Lock(m_Section);
	m_NowState.TotalProgress = v;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! CXg[𒆒f
/*!
 *	BeginInstall() Ă邱
 */
void   Install::OnCancel()
{
	m_Thread.Close();
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ۂɃCXg[sXbh
/*!
 *	\param	Brige	[i ]	nf[^
 */
unt32	Install::InstallThread( volatile CThreadController::BRIGEDATA& Brige )
{
	CShell::CoInitialize();

	INSTALLDATA& Data = m_InstallData;


	const CSetupConfig::INSTALLTYPE Type = Data.pConfig->GetInstallType( Data.InstallTypeNo );


	{
		m_ExecutingInfo.TotalFileSize = 0.0f;
		m_ExecutingInfo.AccessFileSize = 0.0f;

		SetProgressText ( mstring() );
		SetNowProgress  ( 0 );
		SetTotalProgress( 0 );
	}


	{
		//	ECXg[ݒ̍쐬(00%-05%)
		SetProgressText( MAIDTEXT("CXg[邽߂̏W߂Ă܂") );
		SetTotalProgress( (float)TOTALPROGRESS_SETUPBEGIN );

		SetTotalProgress( PER(TOTALPROGRESS_SETUPEND) );
	}


	CXMLWriter		InstallLog;	//	CXg[O

	InstallLog.AscendNode( MAIDTEXT("UninstallInfo") );

	const mstring UninstallerPath = Data.pConfig->GetWindowsFolder() + MAIDTEXT("\\") + MAIDTEXT(s_UNINSTALLER_NAME);
	const mstring UninstallLogFileName = Data.pConfig->GetInstallFolder() + MAIDTEXT("\\") + MAIDTEXT(s_UNINSTALLERINFONAME);


	{
		//	Et@C̃Rs[ & MD5`FbN     (05%-90%)
		SetProgressText( MAIDTEXT("CXg[Jn܂") );
		SetTotalProgress( PER(TOTALPROGRESS_FILECOPYBEGIN) );

		for( int i=0; i<(int)Type.CopyFileList.size(); ++i )
		{
			{
				const float per = float(i) / float(Type.CopyFileList.size());
				const int len = TOTALPROGRESS_FILECOPYEND-TOTALPROGRESS_FILECOPYBEGIN;

				SetTotalProgress( (float(len)*per + float(TOTALPROGRESS_SETUPEND))/float(TOTALPROGRESS_FINAL) );
			}

			const CSetupConfig::INSTALLTYPE::COPYFILE dat = Type.CopyFileList[i];

			//	t@C݂ĂȂfBXNv
			while( true )
			{
				if( CFileRead::IsExist(dat.SrcPath) ) { break; }

				char buf[256];
				sprintf( buf, "fBXN %d hCuɓĂ", dat.DiskNo+1 );

				const int select = ::MessageBox( Data.hWnd, buf, "fBXŇ", MB_OKCANCEL );

				if( select==IDOK )
				{
					continue;
				}else
				{	//	njȂLZŏI
					InstallCancel();
					return 0;
				}
			}


			while( true )
			{
				//	Rs[̊Jn
				switch( FileCopy( dat.DstPath, dat.SrcPath, Brige ) )
				{
				case FUNCTIONRESULT_OK: { }break;
				case FUNCTIONRESULT_CANCEL: { InstallCancel(); return 0;}break;
				default: { return 2; }break;
				}

				//	MD5 `FbN
				if( m_InstallData.IsMD5Check )
				{
					switch( CheckMD5( dat.DstPath, CString::ToLower(dat.MD5), Brige ) )
					{
					case FUNCTIONRESULT_OK: { }break;
					case FUNCTIONRESULT_CANCEL: { InstallCancel(); return 0;}break;
					case FUNCTIONRESULT_ERROR:
						{
							const char* pText = "Rs[t@CjĂ܂\nxCXg[܂H";
							const int select = ::MessageBox( m_InstallData.hWnd, pText, "MD5G[", MB_OKCANCEL );
							
							//	njȂLZŏI
							if( select==IDOK )	{ continue; }
							else				{ InstallCancel();	return 0;	}
						}break;

					default: { return 3; }break;
					}
				}
				//	܂ł΂nj
				break;
			}

			//	Rs[t@C̃Oc
			InstallLog.SetElementName( MAIDTEXT(s_UNINSTALLER_COPYFILE) );
			InstallLog.SetValueText( dat.DstPath );
			InstallLog.NextNode();
		}

		{
	
			//	ACXg[[̃Rs[

			HRSRC hResource = FindResource( NULL, MAKEINTRESOURCE(IDR_UNINSTALL1), "uninstall" );

			MAID_ASSERT( hResource==NULL, MAIDTEXT("uninstall.exe ܂ł") );
			const DWORD ExeSize = SizeofResource( NULL,hResource);

			HGLOBAL hGlobal = LoadResource( NULL, hResource );

			void* pExeImage = LockResource( hGlobal );

			CFileWrite::Write( Data.pConfig->GetWindowsFolder() + MAIDTEXT("\\") + MAIDTEXT(s_UNINSTALLER_NAME), pExeImage, ExeSize );

			FreeResource( hGlobal );
	
		}

		SetTotalProgress( PER(TOTALPROGRESS_FILECOPYEND) );
	}



	{

		//	V[gJbg̍쐬
		SetProgressText( MAIDTEXT("V[gJbg쐬Ă܂") );
		SetTotalProgress( PER(TOTALPROGRESS_SHORTCUTBEGIN) );

		for( int i=0; i<(int)Type.ShortcutList.size(); ++i )
		{
			const CSetupConfig::INSTALLTYPE::SHORTCUT dat = Type.ShortcutList[i];
			const mstring dir = CString::GetDirectory(dat.CreatePath);


			CShell::CreateDirectory( dir, m_ExecutingInfo.CreateDirectoryList );
			CShell::CreateShortCut( dat.CreatePath, dat.TargetObject, dat.Parameters );


			//	Rs[t@C̃Oc
			InstallLog.SetElementName( MAIDTEXT(s_UNINSTALLER_SHORTCUT) );
			InstallLog.SetValueText( dat.CreatePath );
			InstallLog.NextNode();
		}
		SetTotalProgress( PER(TOTALPROGRESS_SHORTCUTEND) );


		SetTotalProgress( PER(TOTALPROGRESS_REGISTORYBEGIN) );


		{
			//	WXgւ̏
			SetProgressText( MAIDTEXT("CXg[WXgɏł܂") );

			{
				CRegistry hReg;

				hReg.Create( CRegistry::KEY_CURRENT_USER, Data.pConfig->GetTargetRegistry() );
				hReg.SetValue( MAIDTEXT("InstallDirectory"), Data.pConfig->GetInstallFolder() );
				hReg.SetValue( MAIDTEXT("InstallType"), Type.InstallTypeName );

				InstallLog.SetElementName( MAIDTEXT(s_UNINSTALLER_CREATEREGISTRY) );
				InstallLog.SetValueText( Data.pConfig->GetTargetRegistry() );
				InstallLog.NextNode();

			}
		}

		{
			CRegistry hReg;

			const mstring SubKeyName = MAIDTEXT(s_UNINSTALLER_CTRLPANEL) + MAIDTEXT("\\") + Data.pConfig->GetGUID();

			hReg.Create( CRegistry::KEY_LOCAL_MACHINE, SubKeyName );

			hReg.SetValue( MAIDTEXT("DisplayName"), Data.pConfig->GetUninstallTittle() );

			const mstring UninstallCommand = UninstallerPath + MAIDTEXT(" \"") + UninstallLogFileName + MAIDTEXT("\"");

			hReg.SetValue( MAIDTEXT("UninstallString"), UninstallCommand );

			InstallLog.SetElementName( MAIDTEXT(s_UNINSTALLER_GUID) );
			InstallLog.SetValueText( Data.pConfig->GetGUID() );
			InstallLog.NextNode();

		}

		SetTotalProgress( PER(TOTALPROGRESS_REGISTORYEND) );
	}

	{
		//	ACXg[f[^̍쐬
		SetProgressText( MAIDTEXT("ACXg[쐬Ă܂") );
		SetTotalProgress( PER(TOTALPROGRESS_UNINSTALLBEGIN) );

		{
			//肽߂fBNg̋L^
			MySTL::set<mstring> s;

			for( int i=0; i<(int)m_ExecutingInfo.CreateDirectoryList.size(); ++i )
			{
				const mstring& fol = m_ExecutingInfo.CreateDirectoryList[i];
				s.insert( CString::ToLower(fol) );
			}

			for( MySTL::set<mstring>::reverse_iterator ite = s.rbegin();
						ite!=s.rend(); ++ite )
			{
				InstallLog.SetElementName( MAIDTEXT(s_UNINSTALLER_CREATEFOLDER) );
				InstallLog.SetValueText( *ite );
				InstallLog.NextNode();
			}
		}
		SetTotalProgress( PER(TOTALPROGRESS_UNINSTALLEND) );
	}

	InstallLog.DescendNode();
	InstallLog.Save( UninstallLogFileName );

	SetProgressText(MAIDTEXT("CXg[܂"));
	SetNowProgress(1);
	SetTotalProgress( 1 );


	m_NowState.Status = STATUS::THREADSTATUS_SUCCESS;

	return 0;
}

void Install::InstallCancel()
{
	SetProgressText( MAIDTEXT("CXg[̓LZ܂") );
	m_NowState.Status = STATUS::THREADSTATUS_CANCEL;
}

void Install::InstallError( const mstring& comment )
{
	SetProgressText( MAIDTEXT("CXg[ɃG[܂\nG[eF") + comment );
	m_NowState.Status = STATUS::THREADSTATUS_ERROR;
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! t@C̃Rs[
/*!
 *	\param	DstFileName		[i ]	쐬fBNg
 *	\param	SrcFileName		[i ]	쐬fBNg
 *	\param	Brige			[i ]	OXbh̖
 *
 *	\return	Rs[ɐ FUNCTIONRESULT_OK
\n			OLZ߂ł FUNCTIONRESULT_CANCEL
\n			ʂ̃G[ FUNCTIONRESULT_ERROR
 */
Install::FUNCTIONRESULT Install::FileCopy( const mstring& DstFileName,  const mstring& SrcFileName, volatile CThreadController::BRIGEDATA& Brige  )
{
	//	fBNg
	CShell::CreateDirectory( CString::GetDirectory(DstFileName), m_ExecutingInfo.CreateDirectoryList );


	CFileWrite hDst;
	CFileRead hSrc;

	hDst.Open(DstFileName,CFileWrite::OPENOPTION_NEW);
	hSrc.Open(SrcFileName);



	SetProgressText( SrcFileName+MAIDTEXT("\n") + DstFileName + MAIDTEXT("ɃRs[Ă܂") );

	const unt32 FileSize = hSrc.GetSize();

	unt32	LimitSize = FileSize;
	unt32	WriteSize = 0;

	while( LimitSize!=0 )
	{
		if( Brige.IsExit )
		{	//	~߂Ă
			return FUNCTIONRESULT_CANCEL;
		}

		const unt32 Size = (unt32)min(COPY_PACET,LimitSize);

		hSrc.Read( COPYBUF, Size );
		hDst.Write( COPYBUF, Size );


		LimitSize -= Size;
		WriteSize += Size;

		m_ExecutingInfo.AccessFileSize += Size;

		{	//	_ŌvZĂȂƁAI[o[t[邱Ƃ
			float32 write = (float32)(int32)WriteSize;
			float32 total = (float32)(int32)FileSize;

			SetNowProgress( write/total );
		}
	}

	return FUNCTIONRESULT_OK;
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! MD5 `FbNs
/*!
 *	\param	DstFileName		[i ]	`FbNst@C
 *	\param	MD5Str			[i ]	̃t@CMD5ił邱Ɓj
 *	\param	Brige			[i ]	OXbh̖
 *
 *	\return	t@Cł FUNCTIONRESULT_OK
\n			OLZ߂ł FUNCTIONRESULT_CANCEL
\n			MD5 Ȃ FUNCTIONRESULT_ERROR
 */
Install::FUNCTIONRESULT	Install::CheckMD5( const mstring& DstFileName, const mstring& MD5Str, volatile CThreadController::BRIGEDATA& Brige )
{
	if( MD5Str.empty() ) { return FUNCTIONRESULT_OK; }

	CFileRead hSrc;

	hSrc.Open(DstFileName);


	SetProgressText( DstFileName + MAIDTEXT("̃t@C`FbNsĂ܂") );

	{
		MD5LIB::MD5_CTX context;

		MD5LIB::MD5Init( &context );

		unt32	LimitSize = hSrc.GetSize();
		unt32	ReadSize = 0;

		while( LimitSize!=0 )
		{
			if( Brige.IsExit )
			{	//	~߂Ă
				return FUNCTIONRESULT_CANCEL;
			}

			const unt32 Size = (unt32)min(MD5CHECKSIZE,LimitSize);

			hSrc.Read( COPYBUF, MD5CHECKSIZE );

			MD5LIB::MD5Update( &context, COPYBUF, Size );

			LimitSize -= Size;
			ReadSize += Size;
			m_ExecutingInfo.AccessFileSize += Size;

			{	//	_ŌvZĂȂƁAI[o[t[邱Ƃ
				float32 write = (float32)(int32)ReadSize;
				float32 total = (float32)(int32)hSrc.GetSize();

				SetNowProgress( write/total );
			}
		}


		mstring NewMD5;
		{
			unsigned char digest[16];

			MD5LIB::MD5Final( digest, &context );

			for( unt32 i=0; i<16; ++i )
			{
				char buf[32];
				sprintf( buf, "%02x", digest[i] );

				NewMD5 += MAIDTEXT(buf);
			}
		}
		if( MD5Str != CString::ToLower(NewMD5) )
		{
			return FUNCTIONRESULT_ERROR;
		}

		::Sleep(1);
	}


	return FUNCTIONRESULT_OK;
}
