#include"../../Maid/FrameWork/Windows/CSingleWindowAppWindows.h"


using namespace Maid;

class CApp : public IGameThread
{
protected:
	void OnLocalSetup( APPCONFIG& conf )
	{

	}

	void OnLocalBegin( const BEGINPARAM& param )
	{
		{
			CGraphic::SCREENMODE m;

			m.Mode = CGraphic::SCREENMODE::TYPE_WINDOW;
			m.Size = SIZE2DI(800,600);
			m.RefreshRate = 0;
			m.IsSoftTnL = false;
			m.IsWaitVSync = true;
			m.IsAspectLock = false;

			m_Graphic.Initialize( m, param.pFontDriver, param.pInfo );
		}

		m_Mouse.Initialize( param.pMouseDriver );
		m_Keybord.Initialize( param.pKeybordDriver, param.pCharCodeDriver );
	}

	void OnLocalLoop()
	{
		m_Mouse.Update();
		m_Keybord.Update();


		SPFONT pFont = m_Graphic.CreateFont( 0, SIZE2DI(16,32), true, false, false );

		{	//	}EXW\
			char buf[256];
			sprintf( buf, "}EXW:%04d,%04d", m_Mouse.GetX(), m_Mouse.GetY() );
			m_Graphic.BltText( POINT2DF(0,0), pFont, COLOR_A08R08G08B08I(0xFF,0xFF,0xFF,0xFF), CString::ConvertSJIStoMAID(buf) );
		}

		if( m_Keybord.IsDown('A' ) )
		{	//	L[{[h`Ă邩H
			m_Graphic.BltText( POINT2DF(0,32), pFont, COLOR_A08R08G08B08I(0xFF,0xFF,0xFF,0xFF), MAIDTEXT("`Ă܂") );

		}

		if( m_Keybord.IsIn('B') )
		{	//	L[{[haꂽuԂH
			m_Graphic.BltText( POINT2DF(0,64), pFont, COLOR_A08R08G08B08I(0xFF,0xFF,0xFF,0xFF), MAIDTEXT("aI") );

		}

		OnNextFrame(m_Graphic);
		::Sleep(10);
	}

	void OnLocalEnd()
	{

	}

	void OnButtonMaximize() 
	{
		const APPCONFIG& conf =	GetAppConfig();

		CGraphic::SCREENMODE m;

		m.Mode = CGraphic::SCREENMODE::TYPE_FULL32;
		m.Size = conf.Graphic.Size;
		m.RefreshRate  = conf.Graphic.RefreshRate;
		m.IsSoftTnL    = conf.Graphic.IsSoftTnL;
		m.IsWaitVSync  = conf.Graphic.IsWaitVSync;
		m.IsAspectLock = conf.Graphic.IsAspectLock;

		m_Graphic.ChangeScreenMode( m );
	}


private:
	CGraphic	m_Graphic;
	CMouse		m_Mouse;
	CKeybord	m_Keybord;
};




int WINAPI WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow )
{
	CSingleWindowAppWindows capp( SPGAMETHREAD( new CApp ) );
	return capp.Run( hInstance, hPrevInstance, lpCmdLine, nCmdShow );
}