#include"../../Maid/FrameWork/Windows/CSingleWindowAppWindows.h"

#include"../../Maid/Graphic/CGraphic.h"

#include"../../Maid/Graphic/CPixelShaderDefault.h"
#include"../../Maid/Graphic/CVertexShaderDefault.h"
#include"../../Maid/Graphic/CVertexMemory.h"
#include"../../Maid/Graphic/CTextureFile.h"

#include"../../Maid/Graphic/CCustomVertexTemplate.h"

#include"../../Maid/Storage/CStorage.h"

#include"../../Maid/Auxiliary/CString.h"

using namespace Maid;

class CApp : public IGameThread
{
protected:
	void OnLocalSetup( APPCONFIG& conf )
	{

	}

	void OnLocalEnd()
	{

	}

	void OnLocalBegin( const BEGINPARAM& param )
	{
		{
			CGraphic::SCREENMODE m;

			m.Mode = CGraphic::SCREENMODE::TYPE_WINDOW;
			m.Size = SIZE2DI(800,600);
			m.RefreshRate = 0;
			m.IsSoftTnL = false;
			m.IsWaitVSync = true;
			m.IsAspectLock = false;

			m_Graphic.Initialize( m, param.pFontDriver, param.pInfo );
		}
		{
			m_Storage.Initialize( );
		}



		camera.SetPerspective( DEGtoRAD(60), 800.0f/600.0f, 0.001f, 100.0f ); 
		camera.SetPosition( POINT3DF( 0,0,-2) ); 
		camera.SetTarget( POINT3DF( 0,0,0) );
		camera.SetUpVector( VECTOR3DF(0,1,0) );


		vs.Create( VERTEXSHADERNAME::COLOR3D );
		ps.Create( PIXELSHADERNAME::VERTEXCOLOR_NORMAL );

		{
			CUSTOMVERTEX_3DCOLOR v[] =
			{
				CUSTOMVERTEX_3DCOLOR(POINT3DF(0,0,0), COLOR_A08R08G08B08I(0xFF,0xFF,0x00,0x00) ),
				CUSTOMVERTEX_3DCOLOR(POINT3DF(0,100,0), COLOR_A08R08G08B08I(0xFF,0xFF,0x00,0x00) ),
				CUSTOMVERTEX_3DCOLOR(POINT3DF(100,100,0), COLOR_A08R08G08B08I(0xFF,0xFF,0x00,0x00) ),
			};

			vertex.Create( v[0].GetVertexFormat(), v, NUMELEMENTS(v) );
		}

		camera.Set2DPosition( 800, 600, 0.01f, 1000.0f );
	}

	void OnLocalLoop()
	{
		m_Graphic.ClearRenderTargetColor( COLOR_R08G08B08I(0x00,0x00,0x80) );
		m_Graphic.ClearRenderTargetZ( 1 );

		const MATRIX4DF mat = camera.GetViewMatrix() * camera.GetProjectionMatrix();
		const MATRIX4DF m = mat.GetTranspose();

		vs.SetConstantF( 0, mat.GetTranspose() );

		m_Graphic.SetVertex( vertex );
		m_Graphic.SetVertexShader( vs );
		m_Graphic.SetPixelShader( ps );

		m_Graphic.DrawPrimitive( CGraphic::PRIMITIVE_TRIANGLESTRIP, 0, 1 );

		//	̃t[
		OnNextFrame(m_Graphic);
		::Sleep(10);
	}


private:
	CGraphic	m_Graphic;
	CStorage	m_Storage;

	CCamera camera;
	CVertexShaderDefault vs;	//	__F̂܂܂ȂVF[_[
	CPixelShaderDefault ps;	//	ʏ`悷sNZVF[_[
	CVertexMemory vertex;

};


int WINAPI WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow )
{
	CSingleWindowAppWindows capp( SPGAMETHREAD( new CApp ) );
	return capp.Run( hInstance, hPrevInstance, lpCmdLine, nCmdShow );
}