/*!
 	@file
 	@brief	LbVRei
 */

#ifndef CacheManager_h
#define CacheManager_h

#include"../Setup/CompileMode.h"

#include<map>
#include<set>
#include<algorithm>

namespace Maid
{ 
	/*!
	 	@class CacheManager CacheManager.h
	 	@brief LbVRei
	 */
	template<class KEY, class DATA>
	class CacheManager
	{
	public:
		CacheManager()
		{
			m_CacheMax = 200;
			m_UpdateCount = 0;
			m_GarbageState= GARBAGESTATE_AUTO;
		}


		enum GARBAGESTATE
		{
			GARBAGESTATE_MANUAL,	//!<	gl Garbage() Ăяo
			GARBAGESTATE_AUTO,		//!<	I Garbage() Ă΂
		};

		void SetGarbageState( GARBAGESTATE state )
		{
			m_GarbageState = state;
		}


		//! o^Ăf[^̎擾
		/*!
		 	o^ĂȂf[^擾悤Ƃ瓮͕słB
		 	K IsExist() Ńf[^݂Ă邩ׂ邱
		 
		 	@param	Key	[i ]	擾f[^̃L[
		 
		 	@return	f[^
		 */
		const DATA& GetData( const KEY& Key )
		{
			m_UpdateCount++;

			CACHELIST::iterator ite = m_CacheList.find( Key );

			CACHEDATA dat = *(ite->second);

			dat.UpdateCount = m_UpdateCount;

			m_Pool.erase( ite->second );
			MySTL::pair<POOL::iterator, bool> ret = m_Pool.insert(dat);
			m_CacheList[Key] = ret.first;

			return ret.first->Data;
		}

		//! f[^݂Ă邩ׂ
		/*!
		 	@param	Key	[i ]	ׂf[^̃L[
		 
		 	@return	f[^݂ĂȂ true
		 */
		bool IsExist( const KEY& Key )
		{
			return m_CacheList.find( Key )!=m_CacheList.end();
		}


		//! f[^̓o^
		/*!
		 	@param	Key		[i ]	o^f[^̃L[
		 	@param	Data	[i ]	o^f[^
		 */
		void Regist( const KEY& Key, const DATA& Data )
		{
 			m_UpdateCount++;

			CACHEDATA dat;
			dat.Key = Key;
			dat.Data= Data;
			dat.UpdateCount = m_UpdateCount;

			MySTL::pair<POOL::iterator, bool> ret = m_Pool.insert(dat);

			if( !(ret.second) ) { return ; }

			m_CacheList[Key] = ret.first;

			if( m_GarbageState == GARBAGESTATE_AUTO )
			{
				Garbage();
			}
		}

		//! o^Ăf[^ׂď
		/*!
		 */
		void ClearAll()
		{
			m_CacheList.clear();
			m_Pool.clear();
		}

		//! o^Ăf[^
		/*!
		 */
		void ClearData( const KEY& Key )
		{
			CACHELIST::iterator ite = m_CacheList.find( Key );

			if( ite==m_CacheList.end() ) { return ; }

			m_Pool.erase( ite->second );
			m_CacheList.erase( Key );
		}

		//! LbVƂĕێ鐔ύX
		/*!
			@param	Size			[i ]	ŒLbVĂ
		 */
		void SetCacheSize( int Size )
		{
			m_CacheMax = Size;
			Garbage();
		}

		//! LbV̑|
		/*!
			m_CacheMax ܂Ō܂
		 */
		void Garbage()
		{
			const int Max = m_CacheMax;

			while( true )
			{
				if( (int)m_CacheList.size()<=Max ) { break; }
				POOL::iterator ite = m_Pool.begin();

				m_CacheList.erase( ite->Key );
				m_Pool.erase( ite );
			}
		}

	private:

		struct CACHEDATA
		{
			KEY		Key;
			DATA	Data;
			int		UpdateCount;

			bool operator < ( const CACHEDATA& rhs ) const
			{
				return UpdateCount < rhs.UpdateCount;
			}
		};

		//!	쐬ꂽ𗭂߂ĂƂ
		typedef MySTL::set<CACHEDATA> POOL;

		typedef MySTL::map<typename KEY,typename POOL::iterator> CACHELIST;


	private:
		CACHELIST		m_CacheList;	//!<	LbV̍쐬ԂŃ\[gĂ郊Xg
		POOL			m_Pool;			//!<	LbVf[^
		int				m_CacheMax;		//!<	LbVێłő吔

		int				m_UpdateCount;	//!<	m_PoolXVꂽԁiRɃLbVj
		GARBAGESTATE	m_GarbageState;
	};
}


#endif