#include"CSoundDecoderWave.h"
#include"../../../auxiliary/CString.h"
#include"../../../auxiliary/Macro.h"
#include"../../../auxiliary/Debug/CAssert.h"
#include"../../../auxiliary/Debug/CWarning.h"
#include"../../../auxiliary/Debug/CException.h"


namespace Maid
{
	/*!
	 	@class	CSoundDecoderWave CSoundDecoderWave.h
	 	@brief	WAVE t@CGR[_[
	 */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! RXgN^
/*!
 */
CSoundDecoderWave::CSoundDecoderWave()
{
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! fXgN^
/*!
 */
CSoundDecoderWave::~CSoundDecoderWave()
{
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! t@C̃[h
/*!
 	Ȃǂ ISoundDecoder::Open QƂ邱
 */
void CSoundDecoderWave::Open( const mstring& FileName )
{
	Close();

	m_hFile.Open( FileName );

	MySTL::vector<unt08> tmp(2048);	//	ŏ\ł傤
	m_hFile.Read( &(tmp[0]), (int)tmp.size() );

	if( (*(unt32*)(&tmp[0]))!=Str2Binary32('R','I','F','F') ||
		(*(unt32*)(&tmp[8]))!=Str2Binary32('W','A','V','E')  ) { MAID_THROWEXCEPTION( MAIDTEXT("wavet@Cł܂") ); }

	unt32 sample;
	{
		unt08*	pNow = &(tmp[12]);
		unt32	dwOffset = 12;

		bool bfmt = false;
		bool bdata= false;
		while( true )
		{
			if( bfmt && bdata ) { break; }

			unt32 type   = *((unt32*)pNow);
			unt32 length = *((unt32*)(pNow+4));

			if( type==Str2Binary32('f','m','t',' ') )
			{
				unt08* pData  = pNow+8;
				memcpy( &m_WaveFormat, pData, length );
				bfmt = true;
			}else if( type==Str2Binary32('d','a','t','a') )
			{
				sample   = length;
				m_BeginOffset = dwOffset+8;
				bdata = true;
			}

			pNow += length+8;
			dwOffset += length+8;
		}

	}

	m_PCMLength = sample;
	m_hFile.Seek( m_BeginOffset, IFileRead::POSITION_BEGIN );
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! fR[h
/*!
 	Ȃǂ ISoundDecoder::Read QƂ邱
 */
int CSoundDecoderWave::Read( void* pDst, int dwSize )
{
	const unt32 pos = GetPosition();
	const unt32 len = GetLength();

	unt32 Red;

	if( pos+dwSize < len )	{ Red = dwSize; }
	else	
	{
		Red = len - pos; 
	}

	return m_hFile.Read( pDst, Red ) ;

}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! fR[hJnʒuړ
/*!
 	Ȃǂ ISoundDecoder::SetPosition QƂ邱
 */
void CSoundDecoderWave::SetPosition( int Offset, POSITION ePos )
{
	IFileRead::POSITION FilePos;

	switch( ePos )
	{
	case ISoundDecoder::BEGIN:	{ FilePos = IFileRead::POSITION_BEGIN;	}break;
	case ISoundDecoder::END:	{ FilePos = IFileRead::POSITION_END;	}break;
	case ISoundDecoder::CURRENT:{ FilePos = IFileRead::POSITION_CURRENT;}break;
	}
	m_hFile.Seek( m_BeginOffset+Offset, FilePos );
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ǂݍ񂾃t@C̉
/*!
 	Ȃǂ ISoundDecoder::Close QƂ邱
 */
void	CSoundDecoderWave::Close()
{
	m_hFile.Close();
	ZERO( &m_WaveFormat, sizeof(m_WaveFormat) );
	m_PCMLength   = 0;
	m_BeginOffset = 0;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ݂̈ʒu̎擾
/*!
 	Ȃǂ ISoundDecoder::GetPosition QƂ邱
 */
int	CSoundDecoderWave::GetPosition()		const
{
	const unt32 FilePos = m_hFile.GetPosition();

	return FilePos-m_BeginOffset;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! Ro[g̃t@C̒擾ioCgPʁj
/*!
 	Ȃǂ ISoundDecoder::GetLength QƂ邱
 */
int	CSoundDecoderWave::GetLength()			const
{
	return m_PCMLength;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! Pb艽Tv邩̎擾
/*!
 	Ȃǂ ISoundDecoder::GetSamplesPerSec QƂ邱
 */
int	CSoundDecoderWave::GetSamplesPerSec()	const
{
	return m_WaveFormat.nSamplesPerSec;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! `l(mono,stereo )̎擾
/*!
 *	Ȃǂ ISoundDecoder::GetChannels QƂ邱
 */
int	CSoundDecoderWave::GetChannels()		const
{
	return m_WaveFormat.nChannels;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! PTvɎgpĂrbgʂ̎擾
/*!
 *	Ȃǂ ISoundDecoder::GetBitsPerSamples QƂ邱
 */
int	CSoundDecoderWave::GetBitsPerSamples()	const
{
	return m_WaveFormat.wBitsPerSample;
}



}
