#ifndef CLightWaveObject_h
#define CLightWaveObject_h

/*!
 	@file
 	@brief	lwoǂݍރNX
 */

#include"../../../Setup/CompileMode.h"
#include"../../../template/Mathematics.h"
#include"../../../Graphic/Color.h"
#include"../../../Auxiliary/FileIO/CFileRead.h"

#include<vector>
#include<list>
#include<map>

namespace Maid
{
	class CLightWaveObject
	{
	public:
		void Load( const mstring& FileName );

		struct CHUNKDATA
		{
			unt32 Name;	//!<	`N̖O
			unt32 Pos;	//!<	擪AhX
			unt32 Size;	//!<	f[^̒
		};

		void Parse( CFileRead& hFile, MySTL::vector<CHUNKDATA>& ChunkList );
		void ParseSub( CFileRead& hFile, int EndPos, MySTL::vector<CHUNKDATA>& ChunkList );


		struct LAYER
		{
			typedef	MySTL::vector<POINT3DF>	PNTS;			//	_z	
			typedef	RECT3DF					BBOX;			//	oEfBO{bNX	
			struct POLS
			{
				enum TYPE
				{
					FACE=0,
					CURV,
					PTCH,
					MBAL,
					BONE,
				};

				typedef MySTL::vector<unt32> INDEX;

				TYPE					Type;
				MySTL::vector<INDEX>	Polygon;
			};

			struct PTAG
			{
				enum TYPE
				{
					SURF,	//	|SɓKpT[tFX
					PART,
					SMGP,
					BONE,	//	{[|S(=={[CfbNX), {[
					BNWT,	//	|SɓKpEFCg}bv
				};
				TYPE	Type;	//!<	̃^Õ^Cv

				struct MAP
				{
					unt32 PolygonNo;
					unt32 TypeNo;
				};
				MySTL::vector<MAP>	MapList;
			};


			struct VMAP
			{
				enum TYPE
				{
					NONE,
					PICK,
					WGHT,
					MNVW,
					TXUV,
					RGB,
					RGBA,
					MORF,
					SPOT
				};

				struct DATA
				{
					MySTL::vector<float> Value;	
				};

				TYPE	Type;
				mstring Name;

				//	Map[_ԍ] łtuƂɃANZXł
				MySTL::map<int,DATA>	Map;
			};

			struct VMAD
			{
				enum TYPE
				{
					NONE,
					PICK,
					WGHT,
					MNVW,
					TXUV,
					RGB,
					RGBA,
					MORF,
					SPOT
				};

				// VMAP ͒_ԍdȂ̂ map łĂĂ񂾂
				// VMAP ͏d\̂ŁAzŎ
				struct DATA
				{
					unt32 VertexNo;			//!<	_ԍ
					unt32 PolygonNo;
					MySTL::vector<float> Value;	
				};

				TYPE	Type;
				mstring Name;
				MySTL::vector<DATA>	Map;
			};

			unt16		Index;			//	CfbNXԍ
			unt16		Flag;			//	̃C[̃tO
			VECTOR3DF	Pivot;
			mstring		Name;			//	C[
			PNTS		PointList;		//	Wz	
			BBOX		BoundingBox;	//	oEfBO{bNX
			MySTL::vector<POLS>		Polygon;
			MySTL::vector<PTAG>		PolygonTagMapping;
			MySTL::vector<VMAP>		VertexMap;
			MySTL::vector<VMAD>		DisVertexMap;
		};

		struct SURFACE
		{
			struct COLR
			{
				COLOR_R32G32B32F	Value;
				unt32				EnvelopeNo;
			};
			struct DIFF
			{
				float	Value;
				unt32	EnvelopeNo;
			};
			struct LUMI
			{
				float	Value;
				unt32	EnvelopeNo;
			};
			struct SPEC
			{
				float	Value;
				unt32	EnvelopeNo;
			};
			struct TRAN
			{
				float	Value;
				unt32	EnvelopeNo;
			};
			struct GLOS
			{
				float	Value;
				unt32	EnvelopeNo;
			};

			struct BLOCK
			{
				struct BASE
				{
					enum TYPE
					{
						IMAP,
						PROC,
						GRAD,
						SHDR,
					};

					enum CHAN
					{
						COLR,
						DIFF,
						LUMI,
						SPEC,
						GLOS,
						REFL,
						TRAN,
						RIND,
						TRNL,
						BUMP
					};

					struct OPAC
					{
						enum TYPE
						{
							NORMAL=0,
							SUB,
							ABS,
							MUL,
							DIV,
							ALPHA,
							TEXURE,
							ADD
						};

						TYPE	Type;
						float	Value;
						unt32	EnvelopeNo;
					};


					enum AXIS
					{
						X,
						Y,
						Z
					};

					TYPE	Type;
					mstring Priority;	//!<	ʂKpDx
					CHAN	Channel;
					bool	IsEnable;
					bool	IsReverseColor;
					OPAC	Opacity;
					AXIS	Axis;
				};

				struct TMAP
				{
					struct CNTR
					{
						float	x,y,z;
						unt32	EnvelopeNo;
					};
					struct SIZE
					{
						float	x,y,z;
						unt32	EnvelopeNo;
					};
					struct ROTA
					{
						float	x,y,z;
						unt32	EnvelopeNo;
					};

					struct FALL
					{
						enum TYPE
						{
							BOX,	//	
							BALL,	//	
							LINER_X,//	jAw
							LINER_Y,//	jAx
							LINER_Z,//	jAy
						};

						TYPE	Type;
						float	x,y,z;
						unt32	EnvelopeNo;
					};

					enum CSYS
					{
						LOCAL,
						WORLD
					};
					CNTR	Center;
					SIZE	Size;		
					ROTA	Rotate;		
					mstring ObjectName;
					FALL	FallOff;
					CSYS	Csys;
				};
				struct IMAP
				{
					//	BASE::IMAPpp[^[
					enum PROJ
					{
						PLANE,
						CIRCLE,
						BALL,
						BOX,
						FRONT,
						UV
					};
					enum AXIS
					{
						X,
						Y,
						Z
					};

					struct WRAP
					{
						enum TYPE
						{
							RESET,
							REPEAT,
							MIRROR,
							EDGE
						};

						TYPE  Type;
						float Cycles;
						unt32 EnvelopeNo;
					};

					PROJ	Projection;
					AXIS	Axis;
					unt32	ImageNo;
					WRAP	WrapW;
					WRAP	WrapH;
					mstring UVMapName;
				};
				struct PROC
				{

				};

				struct GRAD
				{

				};
				struct SHDR
				{

				};
		
				BASE Base;
				TMAP TextureMap;	//	BASE::IMAP,BASE::PROC p
				IMAP ImageMap;		//	BASE::IMAP p
				PROC Procedure;		//	BASE::PROC p
				GRAD Gradient;		//	BASE::GRAD p
				SHDR Shader;		//	BASE::SHDR p
			};

			mstring Name;			//!<	̃T[tFCX̖O
			mstring ParentName;		//!<	eT[tFCX̖O

			COLR	Color;
			DIFF	Diffuse;
			LUMI	Ambient;
			SPEC	Specular;
			TRAN	Trans;
			GLOS	Glossiness;

			MySTL::vector<BLOCK>	BlockList;
		};

		struct CLIP
		{
			enum TYPE
			{
				NONE,
				STIL,
				ISEQ,
				ANIM,
				XREF,
				STCC
			};
			int		ID;
			TYPE	Type;
			mstring	StillImage;	//	Î~t@C
		};


		struct DOCUMENT
		{
			MySTL::vector<mstring>	TagList;		//!< low ŎgĂ镶
			MySTL::list<LAYER>		LayerList;		//!< C[Xg
			MySTL::vector<SURFACE>	SurfaceList;	//!< T[tFCXXg
			MySTL::vector<CLIP>		ClipList;		//!< NbvXg
		};

		DOCUMENT	m_Document;

	private:

		void  LoadTAGS( CFileRead& hFile, const CHUNKDATA& dat, DOCUMENT& doc );
		LAYER* LoadLAYR( CFileRead& hFile, const CHUNKDATA& dat, DOCUMENT& doc );
		void  LoadPNTS( CFileRead& hFile, const CHUNKDATA& dat, LAYER& Layer );
		void  LoadBBOX( CFileRead& hFile, const CHUNKDATA& dat, LAYER& Layer );
		void  LoadPOLS( CFileRead& hFile, const CHUNKDATA& dat, LAYER& Layer );
		void  LoadPTAG( CFileRead& hFile, const CHUNKDATA& dat, LAYER& Layer );
		void  LoadVMAP( CFileRead& hFile, const CHUNKDATA& dat, LAYER& Layer );
		void  LoadVMAD( CFileRead& hFile, const CHUNKDATA& dat, LAYER& Layer );
		void  LoadSURF( CFileRead& hFile, const CHUNKDATA& dat, DOCUMENT& doc );
		void  LoadCLIP( CFileRead& hFile, const CHUNKDATA& dat, DOCUMENT& doc );

		void  LoadSubBLOK( CFileRead& hFile, const CHUNKDATA& dat, SURFACE& surf );
	};
}

#endif
