#include"LoadTexture.h"
#include"CImageFile.h"
#include"../FunctionEnum.h"

#include"../../auxiliary/CString.h"
#include"../../auxiliary/FileIO/CFileRead.h"

namespace Maid
{


using namespace StorageFunction;



SPSTORAGEFUNCTION_RETURNPARAM LoadTexture( const mstring& FileName, const SPSTORAGEFUNCTION_FUNCTIONPARAM& pParam )
{
	boost::shared_ptr<LoadTextureReturn>	pReturn (new LoadTextureReturn);


	pReturn->pTexture.reset( new CTextureBufferMemory );

	const mstring name = FileName;
	const mstring ext = CString::ToLower(CString::GetExtension(FileName));
	CTextureBufferMemory& dst = *(pReturn->pTexture);

	unt08 tmp[16];

	{
		CFileRead hFile;
		hFile.Open( name );
		hFile.Read( tmp, sizeof(tmp) );
	}

	if( tmp[0]=='B' &&  tmp[1]=='M' ) { CBitmapLoader::Load( name, dst ); }
	ef( tmp[0]==0x89 &&  tmp[1]=='P'&&  tmp[2]=='N'&&  tmp[3]=='G' ) { CPNGLoader::Load( name, dst ); }
	ef( tmp[0]==0xFF &&  tmp[1]==0xD8 ) { CJPEGLoader::Load( name, dst ); }

	const SIZE2DI s = dst.GetSize();

	MAID_ASSERT( s.w>1024, MAIDTEXT("1024𒴂Ă܂\nt@C:") << FileName );
	MAID_ASSERT( s.h>1024, MAIDTEXT("c1024𒴂Ă܂\nt@C:") << FileName );
	return pReturn;
}

}