#include"LoadSound.h"
#include"CImageFile.h"
#include"../FunctionEnum.h"

#include"../../auxiliary/CString.h"
#include"../../auxiliary/Debug/CTrace.h"
#include"SoundFileLoader/CSoundDecoderWave.h"
#include"SoundFileLoader/CSoundDecoderOggVorbis.h"

namespace Maid
{



SPSTORAGEFUNCTION_RETURNPARAM LoadSoundStatic( const mstring& FileName, const SPSTORAGEFUNCTION_FUNCTIONPARAM& pParam )
{
	boost::shared_ptr<LoadSoundStaticReturn>	pRet (new LoadSoundStaticReturn);

	pRet->pData.reset( new MySTL::vector<unt08> );


	//	{Ȃ ̓oCiǂݍނ
	//	SoundCardDriver GR[hׂȂ񂾂ǁA߂ǂ̂ŃX[


	//	{ȂoCiēǂނ̂񂾂낤
	//	hĈŊgqI


	SPSOUNDDECODER pDecoder;

	{
		const mstring ext = CString::ToLower(CString::GetExtension(FileName));
		if( ext==MAIDTEXT("wav") ) { pDecoder.reset( new CSoundDecoderWave ); }
		ef( ext==MAIDTEXT("ogg") ) { pDecoder.reset( new CSoundDecoderOggVorbis ); }
		else { MAID_ASSERT( true, MAIDTEXT("sȃt@C") << FileName ); }
	}


	pDecoder->Open( FileName );

	pRet->pData->resize( pDecoder->GetLength() );

	MySTL::vector<unt08>& dst = *(pRet->pData);
	pDecoder->Read( &(dst[0]), pDecoder->GetLength() );

	pRet->Channels      = pDecoder->GetChannels();
	pRet->SamplesPerSec = pDecoder->GetSamplesPerSec();
	pRet->BitsPerSample = pDecoder->GetBitsPerSamples();

	return pRet;
}


///////////////////////////////////////




SPSTORAGEFUNCTION_RETURNPARAM LoadSoundStream( const mstring& FileName, const SPSTORAGEFUNCTION_FUNCTIONPARAM& pParam )
{
	boost::shared_ptr<LoadSoundStreamReturn>	pRet (new LoadSoundStreamReturn);

	//	{Ȃ ̓oCiǂݍނ
	//	SoundCardDriver GR[hׂȂ񂾂ǁA߂ǂ̂ŃX[


	//	{ȂoCiēǂނ̂񂾂낤
	//	hĈŊgqI

	SPSOUNDDECODER pDecoder;

	{
		const mstring ext = CString::ToLower(CString::GetExtension(FileName));
		if( ext==MAIDTEXT("wav") ) { pDecoder.reset( new CSoundDecoderWave ); }
		ef( ext==MAIDTEXT("ogg") ) { pDecoder.reset( new CSoundDecoderOggVorbis ); }
	}


	pDecoder->Open( FileName );

	pRet->pDecoder = pDecoder;

	return pRet;
}
}