#include"CStorageCore.h"
#include"../../Auxiliary/Debug/CAssert.h"
#include"../../Auxiliary/Debug/CTrace.h"

//	Q[ŌĂ΂֐

namespace Maid
{

CStorageCore*	GlobalPointer<CStorageCore>::s_pPointer;

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! RXgN^
/*!	
 */
CStorageCore::CStorageCore()
{
	GlobalPointer<CStorageCore>::Set();
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! fXgN^
/*!	
 */
CStorageCore::~CStorageCore()
{
	Finalize();
	GlobalPointer<CStorageCore>::Clear();
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! s֐̓o^
/*!	
	s֐̏
@code
	SPRETURNPARAM STORAGEFUNCTION( const mstring& FileName, const SPSTORAGEFUNCTION_FUNCTIONPARAM& pParam )
\n	{
\n		return SPRETURNPARAM();
\n	}
@endcode
\n	ƂȂ܂

	@param	FuncNo	[i ]	o^ԍ
	@param	func	[i ]	s֐
 */
void CStorageCore::RegistFunction( int FuncNo, const STORAGEFUNCTION& func )
{
	CThreadMutexLocker Lock(m_FunctionMutex);	//	킴킴ƂKvȂǈꉞ

	MAID_ASSERT( m_FunctionMap.find(FuncNo)!=m_FunctionMap.end(), "֐݂Ă܂" );

	m_FunctionMap[FuncNo] = func;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ̃NX̏
/*!	
	ق̃oĂԑOɂ̊֐Ăł
 */
void CStorageCore::Initialize()
{
	m_ReturnCode.resize(1000);	//	񂾂Ώ\H
	for( int i=0; i<(int)m_ReturnCode.size(); ++i )
	{
		m_ReturnCode[i].State = RETURNCODE::STATE_NONE;
	}

	m_Thread.SetFunc( MakeThreadObject(&CStorageCore::ThreadFunction,this) );
	m_Thread.Execute();
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ̃NX̉
/*!	
	̊֐Ă񂾂Aق̊֐ĂԂƂ֎~܂B
 */
void CStorageCore::Finalize()
{
	m_Thread.Close();
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! w肵t@C̓ǂݍ
/*!	
	@param	FuncNo	 [i ]	s֐ԍ
	@param	FileName [i ]	ǂݍރt@C
	@param	pParam	 [i ]	t@CȊÖ

	@return	ǂݍݏԂ𒲂ׂ邽߂̃nh
 */
int CStorageCore::Execute( int FuncNo, const mstring& FileName, const SPSTORAGEFUNCTION_FUNCTIONPARAM& pParam )
{
	CThreadMutexLocker Lock(m_MessageMutex);

	const int ret = CreateReturnCode();

	POSTMESSAGE mess;

	mess.FunctionNo   = FuncNo;
	mess.ReturnCodeID = ret;
	mess.FileName = FileName;
	mess.pParam = pParam;

	m_MessageQue.push_back(mess);

	return ret;
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! s̓ǂݍݏ𒆒f
/*!	
	@param	no	 [i ]	fԍ(Execute()̖߂l)
 */
void CStorageCore::Cancel( int no )
{
	CThreadMutexLocker Lock(m_MessageMutex);

	POSTMESSAGE mess;

	mess.FunctionNo = POSTMESSAGE::CANCEL;
	mess.ReturnCodeID = no;

	m_MessageQue.push_back(mess);
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ݓǂݍݒ₢킹
/*!	
	@param	no	 [i ]	₢킹ԍ(Execute()̖߂l)

 	@return	no	 [i ]	ǂݍݒȂ true
*/
bool CStorageCore::IsNowLoading( int no )
{
	//	CThreadMutexLocker Lock(m_MessageMutex);
	//	͂ȂĂȂ
	return m_ReturnCode[no].State==RETURNCODE::STATE_LOADING;
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ǂݍ݂̏I߂l擾
/*!	
	ԍAŌĂ񂾏ꍇAQڈȍ~͂Ȃɂ߂܂B

	@param	no	 [i ]	₢킹ԍ(Execute()̖߂l)

 	@return	ǂݍ݌
*/


SPSTORAGEFUNCTION_RETURNPARAM CStorageCore::GetReturnParam( int no )
{
	//	CThreadMutexLocker Lock(m_MessageMutex);
	//	͂ȂĂȂ
	RETURNCODE& code = m_ReturnCode[no];

	SPSTORAGEFUNCTION_RETURNPARAM pRet;

	code.pMess.swap( pRet );				//	̂Qs̏Ԃ͎邱ƁI
	code.State = RETURNCODE::STATE_NONE;	//

	return pRet;
}

int CStorageCore::CreateReturnCode()
{
	//	󂢂ĂIR[hT&쐬
	for( int i=0; i<(int)m_ReturnCode.size(); ++i )
	{
		RETURNCODE& code = m_ReturnCode[i];
		if( code.State == RETURNCODE::STATE_NONE )
		{
			code.State = RETURNCODE::STATE_LOADING;
			return i;
		}
	}

	MAID_ASSERT( true, "̈悪܂" );

	return -1;
}













}

