#include"CSoundDecoderWave.h"
#include"../../auxiliary/CString.h"
#include"../../auxiliary/CAssert.h"
#include"../../auxiliary/CWarning.h"
#include"../../Auxiliary/CString.h"


namespace Maid
{
	/*!
	 *	\class	CSoundDecoderWave CSoundDecoderWave.h
	 *	\brief	WAVE t@CGR[_[
	 */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! RXgN^
/*!
 *
 */
CSoundDecoderWave::CSoundDecoderWave()
{
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! fXgN^
/*!
 *
 */
CSoundDecoderWave::~CSoundDecoderWave()
{
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! t@C̃[h
/*!
 *	Ȃǂ ISoundDecoder::Open QƂ邱
 */
MRESULT CSoundDecoderWave::Open( const MySTL::wstring& FileName )
{
	Close();

	MRESULT ret;
	ret = m_hFile.Open( FileName );
	if( ret!=MRESULT_OK ) { DEN_WARNING( 0, "%s ̓ǂݍ݂Ɏs", CString::ConvertUTF16toSJIS(FileName).c_str() ); return 1; }

	MySTL::vector<uint08> tmp(2048);	//	ŏ\ł傤
	m_hFile.Read( &(tmp[0]), tmp.size() );

	if( (*(uint32*)(&tmp[0]))!=Str2Binary32('R','I','F','F') ||
		(*(uint32*)(&tmp[8]))!=Str2Binary32('W','A','V','E')  ) { DEN_WARNING( 0, "%s wavet@Cł܂", CString::ConvertUTF16toSJIS(FileName).c_str() ); return 2; }

	uint32 sample;
	{
		uint08*	pNow = &(tmp[12]);
		uint32	dwOffset = 12;

		bool bfmt = false;
		bool bdata= false;
		while( true )
		{
			if( bfmt && bdata ) { break; }

			uint32 type   = *((uint32*)pNow);
			uint32 length = *((uint32*)(pNow+4));

			if( type==Str2Binary32('f','m','t',' ') )
			{
				uint08* pData  = pNow+8;
				memcpy( &m_WaveFormat, pData, sizeof(m_WaveFormat) );
				bfmt = true;
			}else if( type==Str2Binary32('d','a','t','a') )
			{
				sample   = length;
				m_BeginOffset = dwOffset+8;
				bdata = true;
			}

			pNow += length+8;
			dwOffset += length+8;
		}

	}

	m_SampleLength = sample / GetBytePerSample();
	m_hFile.Seek( m_BeginOffset, IFileRead::BEGIN );

	return MRESULT_OK;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! fR[h
/*!
 *	Ȃǂ ISoundDecoder::Read QƂ邱
 */
uint32 CSoundDecoderWave::Read( void* pDst, uint32 dwSize )
{
	const uint32 dat = GetBytePerSample();
	const uint32 pos = GetPosition();
	const uint32 len = GetLength();

	uint32 Red;

	if( pos+dwSize < len )	{ Red = dwSize; }
	else	
	{
		Red = len - pos; 
	}

	return m_hFile.Read( pDst, Red*dat ) /dat ;

}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! fR[hJnʒuړ
/*!
 *	Ȃǂ ISoundDecoder::SetPosition QƂ邱
 */
void CSoundDecoderWave::SetPosition( sint32 Offset, POSITION ePos )
{
	const uint32 dat = GetBytePerSample();
	IFileRead::POSITION FilePos;

	switch( ePos )
	{
	case ISoundDecoder::BEGIN:	{ FilePos = IFileRead::BEGIN; }break;
	case ISoundDecoder::END:	{ FilePos = IFileRead::END; }break;
	case ISoundDecoder::CURRENT:{ FilePos = IFileRead::CURRENT; }break;
	}
	m_hFile.Seek( m_BeginOffset+Offset*dat, FilePos );
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ǂݍ񂾃t@C̉
/*!
 *	Ȃǂ ISoundDecoder::Close QƂ邱
 */
void	CSoundDecoderWave::Close()
{
	m_hFile.Close();
	ZeroMemory( &m_WaveFormat, sizeof(m_WaveFormat) );
	m_SampleLength   = 0;
	m_BeginOffset = 0;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ݂̈ʒu̎擾
/*!
 *	Ȃǂ ISoundDecoder::GetPosition QƂ邱
 */
uint32	CSoundDecoderWave::GetPosition()		const
{
	const uint32 Size = GetBytePerSample();
	const uint32 FilePos = m_hFile.GetPosition();

	return (FilePos-m_BeginOffset)/Size;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! Ro[g̃t@C̒擾iTvPʁj
/*!
 *	Ȃǂ ISoundDecoder::GetLength QƂ邱
 */
uint32	CSoundDecoderWave::GetLength()			const
{
	return m_SampleLength;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! Pb艽Tv邩̎擾
/*!
 *	Ȃǂ ISoundDecoder::GetSamplesPerSec QƂ邱
 */
uint32	CSoundDecoderWave::GetSamplesPerSec()	const
{
	return m_WaveFormat.nSamplesPerSec;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! `l(mono,stereo )̎擾
/*!
 *	Ȃǂ ISoundDecoder::GetChannels QƂ邱
 */
uint32	CSoundDecoderWave::GetChannels()		const
{
	return m_WaveFormat.nChannels;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! PTvɎgpĂrbgʂ̎擾
/*!
 *	Ȃǂ ISoundDecoder::GetBitsPerBlock QƂ邱
 */
uint32	CSoundDecoderWave::GetBitsPerBlock()	const
{
	return m_WaveFormat.wBitsPerSample;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ̃NXœǂݍ݂o邩ׂ
/*!
 *	Ȃǂ ResourceFile::Test QƂ邱
 */
MRESULT  CSoundDecoderWave::Test( const MySTL::wstring& FileName )const
{

	if( CString::tolower(CString::GetExtension(FileName))==L"wav" ) { return MRESULT_OK; }

/*
	//	{͂ȂƂ͂ȂقH

	CSoundDecoderWave* pThis = (CSoundDecoderWave*)this;
	DENRESULT ret = pThis->Open( FileName );
	pThis->Close();
*/
	return 1;
}


}
