#ifndef CSoundCardDriverDS8_h
#define CSoundCardDriverDS8_h 

/*!
 	@file
 	@brief	TEhhCo DirectSound8
 */

#include"../../../../Setup/CompileMode.h"
#include"../CSoundCardDriver.h"


#include"DS8Include.h"
#include"../../../../Auxiliary/Windows/CDllWrapper.h"

namespace Maid
{
	/*!
	 	\class	CSoundCardDriverDS8 CSoundCardDriverDS8.h
	 */
	class CSoundCardDriverDS8 : public ISoundCardDriver
	{
	public:
		CSoundCardDriverDS8( HWND hWnd );
		virtual void	Initialize( const PCMBUFFERFORMAT& Format );
		virtual void	Finalize();
		virtual mstring	DeviceCapsStringOut()const;
		virtual SPSOUNDBUFFERPCMSTATIC	CreateBufferPCMStatic( const MySTL::vector<unt08>& buf, const PCMBUFFERFORMAT& fmt )const;
		virtual SPSOUNDBUFFERPCMSTATIC	DuplicateSoundBuffer( const ISoundBufferPCMStatic& pSrc )const;
		virtual SPSOUNDBUFFERPCMSTREAM	CreateBufferPCMStream( const SPSOUNDDECODER& pDecoder )const;

	private:
		HWND			m_hWnd;
		CDllWrapper		m_dsoundDLL;
		SPDIRECTSOUND	m_pDevice;

		com_ptr<IDirectSoundBuffer>	m_pPrimary;

	private:
		void				PlayDammySound();
		com_ptr<IDirectSoundBuffer>	m_pDammy;
	};

}
#endif
