#ifndef CSoundBufferDS8Stream_h
#define CSoundBufferDS8Stream_h 

/*!
 	@file
 	@brief	Xg[TEhobt@ DirectSound8
 */
#include"../../../../Setup/CompileMode.h"
#include"../../../../Storage/DefaultFunction/SoundFileLoader/CSoundDecoder.h"
#include"../CSoundBufferPCMStream.h"
#include"DS8Include.h"

#include<vector>

namespace Maid
{
	/*!
	 	\class	CSoundBufferStreamDS8 CSoundBufferDS8Stream.h
	 */
	class CSoundBufferStreamDS8 : public ISoundBufferPCMStream
	{
	public:
		virtual void	Play();
		virtual void	Stop();
		virtual void	SetVolume( int vol );
		virtual int		GetVolume() const;
		virtual bool	IsPlay() const;
		virtual void	SetLoopState( bool IsLoop );
		virtual void	Update( unt time );

		virtual int	GetSamplePerSec()const;
		virtual int	GetBitPerSample()const;
		virtual int	GetChannel()const;
		virtual int	GetCurrentSample() const;

		void Setup( const SPDSBUFFER& p, const SPSOUNDDECODER& pDecoder );

	protected:
		virtual unt GetBytePosition () const;
		virtual void SetBytePosition ( unt pos );
		virtual void SetByteLoopPosition ( unt pos );

	private:
		void  DecodeMiri( unt time );
		void  DecodeByte( unt DecodeSize );
		const WAVEFORMATEX* GetFormat()const;

	private:
		SPDSBUFFER		m_pBuffer;
		SPSOUNDDECODER	m_pDecoder;
		bool			m_IsLoop;

		unt32			m_WriteCursorLog;	//!<	Oobt@XV̏݃J[\̈ʒu
		unt32			m_WriteOffset;		//!<	g[^łǂ܂ŏ񂾂H

		unt32					m_PlayCursorLog;	//!<	Oobt@XV̍ĐJ[\̈ʒu
		unt32					m_PlayOffset;		//!<	g[^łǂ܂ōĐH
		MySTL::vector<unt08>	m_Buff;		//!<	GetCurrentPositionPCM() Ōobt@

		unt32					m_LoopPositon;

		MySTL::wstring			m_FileName;

		MySTL::vector<unt08>	m_FormatData;
		DSBCAPS					m_Caps;
	};


}
#endif
