#ifndef CSoundCardDriver_h
#define CSoundCardDriver_h 

/*!
 	@file
 	@brief	TEhhCo
 */

#include"../../../Setup/CompileMode.h"
#include"../../../Auxiliary/mstring.h"
#include"../../../Storage/DefaultFunction/SoundFileLoader/CSoundDecoder.h"
#include"CSoundBuffer.h"
#include"CSoundBufferPCMStatic.h"
#include"CSoundBufferPCMStream.h"
#include<boost/smart_ptr.hpp>
#include<vector>

namespace Maid
{
	/*!
	 	\class	ISoundCardDriver CSoundCardDriver.h
	 	\brief	TEhhCoNX
	\n			TEh֌W̃NXׂ͂ẴNXƊ֌W
	 */
	class ISoundCardDriver
	{
	public:
		virtual ~ISoundCardDriver(){}	//!<	fXgN^

		struct PCMBUFFERFORMAT
		{
			int	Channels;			//	`l
			int	SamplesPerSec;		//	Pb̃Tv
			int	BitsPerSample;		//	PTṽrbg
		};

		//! hCȍ
		/*!
		 	@param	Format	[i ]	vC}obt@̃tH[}bg
		 */
		virtual void	Initialize( const PCMBUFFERFORMAT& Format )=0;


		//! J
		/*!
		*/
		virtual void	Finalize()=0;

		//! hCo擾
		/*!
		 	Initialize() 𐬌Ă邱
		 
		 	@return	SoundCaps	[ o]	o͂ꂽ
		 */
		virtual mstring	DeviceCapsStringOut()const=0;



		//! TEhobt@̍쐬
		/*!
		 	@return 쐬ꂽTEhobt@NX
		 */
		virtual SPSOUNDBUFFERPCMSTATIC	CreateBufferPCMStatic( const MySTL::vector<unt08>& buf, const PCMBUFFERFORMAT& fmt )const=0;


		//! TEhobt@̕
		/*!
		 	obt@Ƃ͋L|C^݂ɂЂƂ̃obt@
		 	L邱Ƃɂă̐ߖs@\ł
		 
		 	@param	pSrc	[i ]	̃obt@
		 
		 	@return ꂽTEhobt@NX
		 */
		virtual SPSOUNDBUFFERPCMSTATIC		DuplicateSoundBuffer( const ISoundBufferPCMStatic& pSrc )const=0;


		//! Xg[obt@̍쐬
		/*!
		 	@return 쐬ꂽTEhobt@NX
		 */
		virtual SPSOUNDBUFFERPCMSTREAM	CreateBufferPCMStream( const SPSOUNDDECODER& pDecoder )const=0;


	};

	typedef boost::shared_ptr<ISoundCardDriver> SPSOUNDCARDDRIVER;
}
#endif
