#include"CSoundObjectCore.h"
#include"CSoundMessageImpl1.h"
#include<boost/smart_ptr.hpp>

#include"../../Auxiliary/Debug/CTrace.h"


namespace Maid
{
CSoundObjectCore::CSoundObjectCore()
{
	m_pStatus = NULL;
}


CSoundObjectCore::~CSoundObjectCore()
{
	Delete();
}


void CSoundObjectCore::Play()
{
	const_cast<CSoundCore::BUFFERSTATUS*>(m_pStatus)->IsPlay = true;
	boost::shared_ptr<SoundMessage::Play> p( new SoundMessage::Play );
	PostMessage( p );
}

void CSoundObjectCore::Stop()
{
	const_cast<CSoundCore::BUFFERSTATUS*>(m_pStatus)->IsPlay = false;
	boost::shared_ptr<SoundMessage::Stop> p( new SoundMessage::Stop );
	PostMessage( p );
}


void CSoundObjectCore::SetPosition( int time )
{
	boost::shared_ptr<SoundMessage::SetPosition> p( new SoundMessage::SetPosition );

	p->Position = time;
	PostMessage( p );
}

void CSoundObjectCore::SetLoopPosition( int time )
{
	boost::shared_ptr<SoundMessage::SetLoopPosition> p( new SoundMessage::SetLoopPosition );

	p->Position = time;
	PostMessage( p );
}


void CSoundObjectCore::SetVolume( int vol, int time )
{
	boost::shared_ptr<SoundMessage::SetVolume> p( new SoundMessage::SetVolume );

	p->Volume = vol;
	p->Time   = time;
//	MAID_TRACE( MAIDTEXT("CSoundObjectCore::SetVolume") << this <<  vol << time );

	PostMessage( p );
//	MAID_TRACE( MAIDTEXT("CSoundObjectCore::SetVolumeEnd") << this <<  vol << time );
}

void CSoundObjectCore::SetPlayCount( int count )
{
	boost::shared_ptr<SoundMessage::SetPlayCount> p( new SoundMessage::SetPlayCount );
	p->Count   = count;
	PostMessage( p );
}

int	CSoundObjectCore::GetPosition()
{
	return m_pStatus->Position;
}


int CSoundObjectCore::GetPlayCount()
{
	return m_pStatus->PlayCount;
}

bool CSoundObjectCore::IsPlay()
{
	return m_pStatus->IsPlay;
}


void CSoundObjectCore::Delete()
{
	if( m_pStatus==NULL ) { return ; }

	boost::shared_ptr<SoundMessage::DeleteBuffer> p( new SoundMessage::DeleteBuffer );
	PostMessage( p );
	m_pStatus = NULL;
}

void CSoundObjectCore::LoadPCMStatic( const boost::shared_ptr<MySTL::vector<unt08> >& pData, int SamplesPerSec, int BitsPerSample, int Channels )
{
	Delete();

	boost::shared_ptr<SoundMessage::LoadPCMStatic> pLoad( new SoundMessage::LoadPCMStatic );

	pLoad->pData = pData;
	pLoad->Format.SamplesPerSec = SamplesPerSec;
	pLoad->Format.BitsPerSample = BitsPerSample;
	pLoad->Format.Channels = Channels;

	m_pStatus = GlobalPointer<CSoundCore>::Get()->CreateBufferStatus();
	PostMessage( pLoad );
}

void CSoundObjectCore::LoadPCMStream( const SPSOUNDDECODER& pDecoder )
{
	Delete();

	boost::shared_ptr<SoundMessage::LoadPCMStream> p( new SoundMessage::LoadPCMStream );
	p->pDecoder = pDecoder;

	m_pStatus = GlobalPointer<CSoundCore>::Get()->CreateBufferStatus();
	PostMessage( p );
}

void CSoundObjectCore::LoadPCMStatic( const SPSOUNDOBJECTCORE& pObj )
{
	Delete();

	boost::shared_ptr<SoundMessage::LoadPCMStaticClone> pLoad( new SoundMessage::LoadPCMStaticClone );

	pLoad->SrcID = pObj->m_pStatus->ID;

	m_pStatus = GlobalPointer<CSoundCore>::Get()->CreateBufferStatus();
	PostMessage( pLoad );
}



void CSoundObjectCore::PostMessage( const SPSOUNDMESSAGE& pMessage )
{
//	MAID_TRACE( MAIDTEXT("CSoundObjectCore::PostMessage") << this );
	if( m_pStatus==NULL ) { return; }
	pMessage->ID = m_pStatus->ID;
//	MAID_TRACE( MAIDTEXT("CSoundObjectCore::PostMessage") << this << MAIDTEXT(" ") << m_pStatus->ID );
	GlobalPointer<CSoundCore>::Get()->PostMessage( pMessage );
//	MAID_TRACE( MAIDTEXT("CSoundObjectCore::PostMessageEnd") << this << MAIDTEXT(" ") << m_pStatus->ID );
}


}


