/*!
 	\file
 	\brief	ꂼ̌`ɂt@CoblɕϊC^[tF[X
 */

#ifndef CSoundDecoder_h
#define CSoundDecoder_h 

#include"../../Setup/CompileMode.h"


#include<boost/smart_ptr.hpp>

namespace Maid
{
	/*!
	 	@class	ISoundDecoder CSoundDecoder.h
	 	@brief	TEht@C̊{NX
	\n			̃NXpčs܂
	 */

	class ISoundDecoder
	{
	public:

		virtual ~ISoundDecoder(){}	//!<	fXgN^

		//! fR[_̃I[v
		/*!
		 */
		virtual void Open() = 0;

		//! fR[_̉
		/*!
		 */
		virtual void Close()=0;

		//! fR[h
		/*!
		 	@param	pDst	[i ]	܂obt@
		 	@param	dwSize	[i ]	ޗʁiTvj
		 
		 	@return ۂɃfR[hʁiTvPʁj
		 */
		virtual int	Decode( void* pDst, int dwSize )=0;

		enum POSITION
		{
			BEGIN,		//!<	t@C̐擪
			END,		//!<	t@C̏I[
			CURRENT,	//!<	݂̈ʒu
		};

		//! fR[hJnʒuړ
		/*!
		 	@param	Offset	[i ]	VʒuiTvPʁj
		 	@param	ePos	[i ]	ǂ̈ʒuړJn邩H
		 */
		virtual void SetPosition( int Offset, POSITION Pos )=0;


		//! ݂̈ʒu̎擾
		/*!
		 	@return ݂̈ʒuiTvPʁj
		 */
		virtual int GetPosition()			const= 0;

		//! Ro[g̃t@C̒擾iTvPʁj
		/*!
		 	TvŎ擾̂Œ
		 
		 	@return t@C̒iTvPʁj
		 */
		virtual int GetLength()			const= 0;

		//! Pb艽Tv邩̎擾
		/*!
		 	@return g
		 */
		virtual int GetSamplesPerSec()	const= 0;

		//! `l(mono,stereo )̎擾
		/*!
		 	@return `l
		 */
		virtual int GetChannels()		const= 0;

		//! PubNɎgpĂrbgʂ̎擾
		/*!
		 	@return rbg
		 */
		virtual int GetBitsPerBlock()	const= 0;

		//! PTvɎgpĂoCgʂ̎擾
		/*!
		 	@return oCg
		 */
		int GetBytePerSample()	const
		{
			return GetChannels()*GetBitsPerBlock()/8;
		};
	};

	typedef boost::shared_ptr<ISoundDecoder> SPSOUNDDECODER;
}

#endif