/*!	
	@file
	@brief	Q[ňTEhIuWFNg
*/

#ifndef CSoundObject_h
#define CSoundObject_h

#include"../Setup/CompileMode.h"
#include"../template/GlobalPointer.h"
#include"CSoundFileStatic.h"
#include"CSoundFileStream.h"


namespace Maid
{
	class CSound;
	class CSoundObject: public GlobalPointer<CSound>
	{
	public:
		CSoundObject();
		CSoundObject( const CSoundObject& rha );
		~CSoundObject();

		enum
		{
			VOLUME_MIN = 0,
			VOLUME_DEFAULT = 5000,
			VOLUME_MAX = 10000,

			PLAY_LOOP = -1,
		};

		enum TYPE
		{
			TYPE_SE=0,
			TYPE_BGM,
			TYPE_VOICE
		};

		void Load( TYPE type, const mstring& FileName, bool IsStream = false );
		void Delete();

		void Play( int count = 1 );
		void Stop();
		void Pause();
		void Resume();
		void SetPosition( int time );
		void SetVolume( int vol, int time );
		void SetLoopPosition( int time );

		void FadeIn( int time );
		void FadeOut( int time );

		bool IsPlay();
		bool IsNowLoading();

		int GetPosition();
		int GetVolume();

		void UpdateVolume( int time );

		bool IsLoopPlay();
		bool IsStream();

	public:
		CSoundObject& operator=( const CSoundObject& rha );

	private:
		SPSOUNDOBJECTCORE	GetObject();
		bool _IsNowLoading();
		int  CalcVolume();


	private:
		CSoundFileStatic	m_Static;
		CSoundFileStream	m_Stream;
		bool				m_IsStream;
		bool	m_IsLoopPlay;
		bool	m_IsLoad;
		bool	m_IsFileLoad;

		bool	m_IsPrevPlay;	//	XgbvOɖĂ?

		int m_Volume;
		int m_Position;

		TYPE	m_Type;
	};

}

#endif
