/*!	
	@file
	@brief	Q[ňTEhǗNX
*/

#ifndef CSound_h
#define CSound_h

#include"../Setup/CompileMode.h"
#include"Core/CSoundCore.h"
#include"../template/GlobalPointer.h"
#include"CSoundObject.h"
#include<set>

namespace Maid
{
	class CSoundObject;
	class CSoundCore;
	class CSound : public GlobalPointer<CSound>, public GlobalPointer<CSoundCore>
	{
	public:
		CSound();
		virtual ~CSound();

		enum
		{
			VOLUME_MIN = 0,
			VOLUME_DEFAULT = 5000,
			VOLUME_MAX = 10000,
		};

		void Initialize();
		void Finalize();

		void SetGlobalMute( bool IsMute );
		bool GetGlobalMute();
		void SetGlobalVolume( int vol );
		int  GetGlobalVolume();

		void AddSoundObject( CSoundObject* pObj );
		void DelSoundObject( CSoundObject* pObj );

		void VolumeUpdate();

		void SetVolume( int type, int vol );
		void SetMute( int type, bool IsMute );
		int  GetVolume( int type );
		bool IsMute( int type );

		void SendDeviceCaps();
		mstring GetDeviceCaps();

		void PauseAll();
		void ResumeAll();

	protected:
		int			m_GlobalVolume;
		bool		m_IsMute;

		typedef MySTL::set<CSoundObject*> OBJECTLIST;
		OBJECTLIST	m_ObjectList;

		struct GLOBALINFO
		{
			GLOBALINFO();
			int Volume;
			bool IsMute;
		};

		GLOBALINFO	m_GlobalInfo[3];

	};
}

#endif