/*!
 	@file
 	@brief	}EXhCo
\n			̃NXpĊenrƂ̋@\bv܂
 */

#ifndef CMouseDriver_h
#define CMouseDriver_h

#include"../../Setup/CompileMode.h"
#include"../../Auxiliary/Macro.h"
#include<vector>
#include<boost/smart_ptr.hpp>

namespace Maid
{
	/*!
	 	@class	IMouseDriver CMouseDriver.h
	 	@brief	}EXhCo
	\n			o֐̎w Index 
	\n			0..w   1..x   2..zC[  3ȍ~..g}EX
	\n			ɂȂĂ܂
	 */

	class IMouseDriver
	{
	public:
		virtual ~IMouseDriver()=0{};	//!<	fXgN^

		//! }EXhCȍ
		/*!
		 	@return ɐ MRESULT_OK
		\n			Ɏs MRESULT_OK ȊO
		 */
		virtual void	Initialize()=0;
		//! }EXhCỏ
		/*!
		 */
		virtual void		Finalize()=0;

		//! e̍Wъe{^Ă邩擾
		/*!
		 	@param	PosList	[ o]	ȅ
		 	@param	KeyList	[ o]	e{^̏
		 */
		virtual void	GetState( MySTL::vector<int>& PosList, MySTL::vector<bool>& KeyList ) const=0;


		//! ̃hCoŎʂł鎲̐擾
		/*!
		 	@return ̐
		 */
		virtual int	GetPositionMax() const=0;

		//! ̃hCoŎʂł{^̐擾
		/*!
		 	@return {^̐
		 */
		virtual int	GetButtonMax() const=0;

		//! OSŋĂ}EXJ[\\E\
		/*!
			@param	IsShow [i ]	\Ȃ true
		 */
		virtual void SetDrawHardWareCursor( bool IsShow )=0;

		//! OSŋĂ}EXJ[\\Ă邩H
		/*!
		 	@retval true  \Ă
		 	@retval false \ĂȂ
		 */
		virtual bool IsCursorShow() const=0;
	};

	typedef boost::shared_ptr<IMouseDriver> SPMOUSEDRIVER;

}

#endif