/*!
 	@file
 	@brief IME NX
 */

#ifndef CInputMethodDriver_h
#define CInputMethodDriver_h

#include"../../Setup/CompileMode.h"
#include"../../Auxiliary/Macro.h"
#include"../../Auxiliary/mstring.h"

#include<boost/smart_ptr.hpp>
#include<boost/function.hpp>

namespace Maid
{
	/*!
	 	@class	IInputMethodDriver CInputMethodDriver.h
	 	@brief	IME NX
	\n			edoǗNX
	\n			̃NX͕`sȂ̂łق̃NXōsKv܂B
	 */

	class IInputMethodDriver
	{
	public:
		virtual ~IInputMethodDriver(){}

		//! FEP ̋N
		/*!
		 */
		virtual void Open() =0;

		//! FEP ̏I
		/*!
		 */
		virtual void Close()=0;


		//! FEP Ă邩H
		/*!
		 	@return edoĂȂ true
		 \n			ĂȂȂ false
		 */
		virtual bool IsOpen() const=0;

		//! ݓ͒H
		/*!
		 	edoNĂA܂ꕶ͂ĂȂƂ͓͒łȂƂ݂Ȃ܂
		 	̊֐Ap~邩
		 
		 	@return	͒Ȃ true
		 */
		virtual bool IsInput() const=0;

		//! ϊʒu̎擾
		/*!
		 	@return	ϊʒu
		 */
		virtual int GetConvertPos() const=0;

		//! J[\ʒu̎擾
		/*!
		 	@return	J[\ʒu
		 */
		virtual int GetCursorPos() const=0;

		//! ϊ␔̎擾
		/*!
		 	@return ϊ␔
		 */
		virtual int GetCandidateCount() const=0;

		//! ݑI𒆂̕ϊ̎擾
		/*!
		 	@return ϊʒu
		 */
		virtual int GetCandidateSelect() const=0;

		//! w肳ꂽCfbNX̕ϊ擾
		/*!
		 	@return ϊ╶
		 */
		virtual mstring GetCandidateString( int Index) const=0;

		//! FEP͕̎擾
		/*!
		 	@return	͒̕
		 */
		virtual mstring GetCompString() const=0;


		typedef boost::function1<void, const mstring&>	RESULTCODEFUNCTION;

		//! m肳ꂽꍇAR[obN֐̐ݒ
		/*!
		 	@param	Function	[i ]	ݒ肷֐ void XXXX( STR ) ̌`ł邱
		\n								STR m肳ꂽɂȂ܂
		 */
		virtual void SetResultCodeFunction( const RESULTCODEFUNCTION& Function )=0;

	};

	#define MakeResultCodeFunctionObject(pFunc,pObject) boost::bind( pFunc, pObject, _1 )

	typedef boost::shared_ptr<IInputMethodDriver> SPINPUTMETHODDRIVER;

}

#endif
