
/*!
 	@file
 	@brief	}EX͂ǗNX
 */

#ifndef CMouse_h
#define CMouse_h

#include"../Setup/CompileMode.h"
#include"../Auxiliary/Macro.h"
#include"../template/Mathematics.h"
#include"Driver/CMouseDriver.h"
#include"Driver/CInputDriver.h"


namespace Maid
{
	class CMouse
	{
	public:
		CMouse();
		virtual ~CMouse();

		void Initialize( const SPMOUSEDRIVER& pDriver );

		void Update();

		int	GetX() const;
		int	GetY() const;
		int	GetWheel() const;
		int	GetPos( unt Index ) const;
		int	GetDeltaX() const;
		int	GetDeltaY() const;
		int	GetDeltaWheel() const;
		int	GetDelta( unt Index ) const;

		bool	IsDownL() const;
		bool	IsDownR() const;
		bool	IsDownWheel() const;
		bool	IsDown( unt Index ) const;
		bool	IsInL() const;
		bool	IsInR() const;
		bool	IsInWheel() const;
		bool	IsIn( unt Index ) const;

		bool	IsOutL() const;
		bool	IsOutR() const;
		bool	IsOutWheel() const;
		bool	IsOut( unt Index ) const;

		bool	IsRepeatL( unt Frame ) const;
		bool	IsRepeatR( unt Frame ) const;
		bool	IsRepeatWheel( unt Frame ) const;
		bool	IsRepeat( unt Index, unt Frame ) const;

		void SetClipRange( const RECT2DI& Range );
		void SetMapping( const RECT2DI& map );
		bool IsClipIn() const;

	protected:
		const SPMOUSEDRIVER& GetMouseDriver() { return m_pMouseDriver; }
	private:

		struct BUTTONSTATE
		{
			BUTTONSTATE() :DownCount(0),IsOut(false){}
			unt		DownCount;
			bool	IsOut;
		};

		MySTL::vector<int>			m_PrevList;
		MySTL::vector<int>			m_PosList;
		MySTL::vector<BUTTONSTATE>	m_ButtonList;
		SPMOUSEDRIVER				m_pMouseDriver;

		POINT2DI	m_RealPos;
		RECT2DI		m_ClipRange;
		RECT2DI		m_Mapping;
	};

}

#endif