#include"CKeybord.h"
#include"../Auxiliary/Debug/CAssert.h"
#include"../Auxiliary/CString.h"


namespace Maid
{
	/*!
	 	@class	CKeybord CKeybord.h
	 	@brief	L[{[h͂ǗNX
	 */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! RXgN^
/*!
 */
CKeybord::CKeybord()
{

}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! fXgN^
/*!
 */
CKeybord::~CKeybord()
{
	if( m_pKeybordDriver.get()!=NULL ) { m_pKeybordDriver->Finalize(); }
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! L[{[h̏
/*!
 	@param	pDriver	[i ]	Vݒ肷hCo
 */
void CKeybord::Initialize( const SPKEYBORDDRIVER& pKey, const SPCHARCODEDRIVER& pChar )
{
	m_pKeybordDriver  = pKey;
	m_pCharCodeDriver = pChar;

	m_ButtonList.resize( m_pKeybordDriver->GetButtonnMax() );
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! R[hhCoR[obN֐̐ݒ
/*!
 	@param	Function	[i ]	֐
 */
void CKeybord::SetCharCodeFunction( const ICharCodeDriver::CHARCODEFUNCTION& Function )
{
	m_Function = Function;
}

void CKeybord::OnCharCode( unt32 code )
{
	if( !m_Function ) { return; }
	m_Function( code );
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! L[{[h̏ԂXV
/*!
 	t[ɂPĂяo
 */
void CKeybord::Update()
{
	MySTL::vector<bool> KeyList(m_ButtonList.size());
	m_pKeybordDriver->IsDown(KeyList);

	for( int i=0; i<(int)KeyList.size(); ++i )
	{
		//	p/Sp@{^͖ɂĂ
		//	OSłhld̃tbNƂĂăhC
		if( i==0xE5 ) { continue; }

		const bool IsDown  = KeyList[i];
		BUTTONSTATE& state = m_ButtonList[i];

		if( IsDown )
		{
			state.DownCount++;	//	I[o[t[邱Ƃ邯ǁEEEES(LM*)T
		}else
		{
			state.IsOut = state.DownCount!=0;
			state.DownCount = 0;
		}
	}
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! L[{[h̏Ԃ̏
/*!
 	ق̃EBhE_CAOoƂȂǂɁA{^̏ԂȂ邯[
 	ȂƂɌĂяoĂBiʏ͂܂j
 */
void CKeybord::Flash()
{
	m_pKeybordDriver->Reset();
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! {^Ă邩ׂ
/*!
 	@param	Index	[i ]	擾{^
 
 	@return Ă邩H
 */
bool CKeybord::IsDown( unt08 Index ) const
{
	MAID_ASSERT( !(Index<m_ButtonList.size()), "{^̎w肪ł " << Index << " "<< m_ButtonList.size() );
	return m_ButtonList[Index].DownCount!=0;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! w肵{^ꂽuԂׂ
/*!
 	@param	Index	[i ]	擾{^
 
 	@return Ă邩H
 */
bool CKeybord::IsIn( unt08 Index ) const
{
	MAID_ASSERT( !(Index<m_ButtonList.size()), "{^̎w肪ł " << Index << " "<< m_ButtonList.size() );
	return m_ButtonList[Index].DownCount==1;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! w肵{^ꂽuԂׂ
/*!
 	@param	Index	[i ]	擾{^
 
 	@return Ă邩H
 */
bool CKeybord::IsOut( unt08 Index ) const
{
	MAID_ASSERT( !(Index<m_ButtonList.size()), "{^̎w肪ł " << Index << " "<< m_ButtonList.size() );
	return m_ButtonList[Index].IsOut;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! w肵{^Ĉ莞Ԍo߂ׂ
/*!
 	@param	Index	[i ]	擾{^
 	@param	Frame	[i ]	s[gԊu
 
 	@return Ă邩H
 */
bool CKeybord::IsRepeat( unt08 Index, unt Frame  ) const
{
	MAID_ASSERT( !(Index<m_ButtonList.size()), "{^̎w肪ł " << Index << " "<< m_ButtonList.size() );
	return (m_ButtonList[Index].DownCount%Frame)==1;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! w肵{^Ĉ莞Ԍo߂ׂ
/*!
 	@param	Index		[i ]	擾{^
 	@param	Frame		[i ]	s[gԊu
 	@param	BeginFrame	[i ]	s[g`FbNJn鎞
 
 	@return Ă邩H
 */
bool CKeybord::IsRepeat( unt08 Index, unt Frame, unt BeginFrame  ) const
{
	MAID_ASSERT( !(Index<m_ButtonList.size()), "{^̎w肪ł " << Index << " "<< m_ButtonList.size() );

	const BUTTONSTATE& state = m_ButtonList[Index];

	if( state.DownCount<BeginFrame )
	{
		return state.DownCount==1;
	}

	return ((state.DownCount-BeginFrame)%Frame)==0;
}


}

