#include"CInputMethod.h"
#include"../auxiliary/Debug/CAssert.h"


namespace Maid
{
	/*!
	 	@class	CInputMethod CInputMethod.h
	 	@brief	IME͂ǗNX
	 */


void CInputMethod::Initialize( const SPINPUTMETHODDRIVER& pDriver )
{
	m_pDriver = pDriver;
}

void CInputMethod::OnResult( const mstring& str )
{
	if( !m_Function ) { return; }
	m_Function( str );
}

void CInputMethod::SetResultFunction( const IInputMethodDriver::RESULTCODEFUNCTION& Function )
{
	m_Function = Function;
}

bool CInputMethod::IsOpen() const
{
	return m_pDriver->IsOpen();
}

mstring CInputMethod::GetCompString() const
{
	return m_pDriver->GetCompString();
}

int CInputMethod::GetCursorPos() const
{
	return m_pDriver->GetCursorPos();
}

}