#ifndef DefaultVertexShader_h
#define DefaultVertexShader_h

#include"../../../../../../Setup/CompileMode.h"
#include"../D3D9Include.h"
#include"../CVertexShaderBufferD3D9.h"

namespace Maid
{
	class VS_RHWCOLOR : public CVertexShaderBufferD3D9
	{
	public:
		virtual void Setup( const SPD3DDEVICE& pDevice )
		{
			pDevice->SetVertexDeclaration( NULL );
			pDevice->SetVertexShader( NULL );
			pDevice->SetFVF( D3DFVF_XYZRHW|D3DFVF_DIFFUSE );
		}
	};

	class VS_SPRITE : public CVertexShaderBufferD3D9
	{
	public:
		virtual void Setup( const SPD3DDEVICE& pDevice )
		{
			pDevice->SetVertexDeclaration( NULL );
			pDevice->SetVertexShader( NULL );
			pDevice->SetFVF( D3DFVF_XYZRHW|D3DFVF_DIFFUSE|D3DFVF_TEX1 );
		}
	};

	class VS_HOOK : public CVertexShaderBufferD3D9
	{
	public:
		void SetupWVP( const SPD3DDEVICE& pDevice  )
		{
			pDevice->SetSoftwareVertexProcessing( FALSE );
			D3DXMATRIX src;
			D3DXMATRIX dst;

			pDevice->GetVertexShaderConstantF( 0, &(src._11), 4 );

			D3DXMatrixTranspose( &dst, &src );

			pDevice->SetTransform( D3DTS_WORLDMATRIX(0), &dst );
		}
	};


	class VS_XYZCOLOR : public VS_HOOK
	{
	public:
		virtual void Setup( const SPD3DDEVICE& pDevice )
		{
			pDevice->SetVertexDeclaration( NULL );
			pDevice->SetVertexShader( NULL );
			pDevice->SetFVF( D3DFVF_XYZ|D3DFVF_DIFFUSE );

			pDevice->SetRenderState( D3DRS_LIGHTING, FALSE );

			SetupWVP(pDevice);
		}
	};

	class VS_XYZSPRITE : public VS_HOOK
	{
	public:
		virtual void Setup( const SPD3DDEVICE& pDevice )
		{
			pDevice->SetVertexDeclaration( NULL );
			pDevice->SetVertexShader( NULL );
			pDevice->SetFVF( D3DFVF_XYZ|D3DFVF_DIFFUSE|D3DFVF_TEX1 );

			pDevice->SetRenderState( D3DRS_LIGHTING, FALSE );
			SetupWVP(pDevice);
		}
	};

	class VS_XYZSPRITEMASK : public VS_HOOK
	{
	public:
		virtual void Setup( const SPD3DDEVICE& pDevice )
		{
			pDevice->SetVertexDeclaration( NULL );
			pDevice->SetVertexShader( NULL );
			pDevice->SetFVF( D3DFVF_XYZ|D3DFVF_DIFFUSE|D3DFVF_TEX1|D3DFVF_TEX2 );

			pDevice->SetRenderState( D3DRS_LIGHTING, FALSE );
			SetupWVP(pDevice);
		}
	};

	class VS_SOFTWARE : public CVertexShaderBufferD3D9
	{
	public:
		VS_SOFTWARE( const SPD3DVERTEXSHADERBUFFER&	pBuffer )
		{
			m_pBuffer = pBuffer;
		}


		virtual void Setup( const SPD3DDEVICE& pDevice )
		{
		//	pDevice->SetSoftwareVertexProcessing( TRUE );
			pDevice->SetVertexShader( m_pBuffer.get() );
		}

	private:
		SPD3DVERTEXSHADERBUFFER	m_pBuffer;
	};
}

#endif