#ifndef DefaultPixelShader_h
#define DefaultPixelShader_h

#include"../../../../../../Setup/CompileMode.h"
#include"../D3D9Include.h"
#include"../CPixelShaderBufferD3D9.h"

namespace Maid
{
	//	_F̂܂ܗ
	class PS_VERTEXCOLOR_NORMAL : public CPixelShaderBufferD3D9
	{
	public:
		virtual void Setup( const SPD3DDEVICE& pDevice )
		{
			pDevice->SetTextureStageState( 0, D3DTSS_COLOROP,	D3DTOP_SELECTARG1 );
			pDevice->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_DIFFUSE );
			pDevice->SetTextureStageState( 0, D3DTSS_COLORARG2, D3DTA_DIFFUSE );
			pDevice->SetTextureStageState( 1, D3DTSS_COLOROP,	D3DTOP_DISABLE );

			pDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP,	D3DTOP_SELECTARG1 );
			pDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG1, D3DTA_DIFFUSE );
			pDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG2, D3DTA_DIFFUSE );
			pDevice->SetTextureStageState( 1, D3DTSS_ALPHAOP,	D3DTOP_DISABLE );

			pDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, TRUE );
			pDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA );
			pDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_SRCALPHA);
			pDevice->SetRenderState(D3DRS_BLENDOP, D3DBLENDOP_ADD);
		}
	};


	class PS_VERTEXCOLOR_ADD : public CPixelShaderBufferD3D9
	{
	public:
		virtual void Setup( const SPD3DDEVICE& pDevice )
		{
			pDevice->SetTextureStageState( 0, D3DTSS_COLOROP,	D3DTOP_SELECTARG1 );
			pDevice->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_DIFFUSE );
			pDevice->SetTextureStageState( 0, D3DTSS_COLORARG2, D3DTA_DIFFUSE );
			pDevice->SetTextureStageState( 1, D3DTSS_COLOROP,	D3DTOP_DISABLE );

			pDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP,	D3DTOP_SELECTARG1 );
			pDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG1, D3DTA_DIFFUSE );
			pDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG2, D3DTA_DIFFUSE );
			pDevice->SetTextureStageState( 1, D3DTSS_ALPHAOP,	D3DTOP_DISABLE );

			pDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, TRUE );
			pDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_ONE );
			pDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_SRCALPHA );
			pDevice->SetRenderState(D3DRS_BLENDOP, D3DBLENDOP_ADD);
		}
	};


	class PS_VERTEXCOLOR_SUB : public CPixelShaderBufferD3D9
	{
	public:
		virtual void Setup( const SPD3DDEVICE& pDevice )
		{
			pDevice->SetTextureStageState( 0, D3DTSS_COLOROP,	D3DTOP_SELECTARG1 );
			pDevice->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_DIFFUSE );
			pDevice->SetTextureStageState( 0, D3DTSS_COLORARG2, D3DTA_DIFFUSE );
			pDevice->SetTextureStageState( 1, D3DTSS_COLOROP,	D3DTOP_DISABLE );

			pDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP,	D3DTOP_SELECTARG1 );
			pDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG1, D3DTA_DIFFUSE );
			pDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG2, D3DTA_DIFFUSE );
			pDevice->SetTextureStageState( 1, D3DTSS_ALPHAOP,	D3DTOP_DISABLE );

			pDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, TRUE );
			pDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA );
			pDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_SRCALPHA);
			pDevice->SetRenderState(D3DRS_BLENDOP, D3DBLENDOP_REVSUBTRACT);
		}
	};


	class PS_VERTEXCOLOR_MUL : public CPixelShaderBufferD3D9
	{
	public:
		virtual void Setup( const SPD3DDEVICE& pDevice )
		{
			pDevice->SetTextureStageState( 0, D3DTSS_COLOROP,	D3DTOP_SELECTARG1 );
			pDevice->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_DIFFUSE );
			pDevice->SetTextureStageState( 0, D3DTSS_COLORARG2, D3DTA_DIFFUSE );
			pDevice->SetTextureStageState( 1, D3DTSS_COLOROP,	D3DTOP_DISABLE );

			pDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP,	D3DTOP_SELECTARG1 );
			pDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG1, D3DTA_DIFFUSE );
			pDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG2, D3DTA_DIFFUSE );
			pDevice->SetTextureStageState( 1, D3DTSS_ALPHAOP,	D3DTOP_DISABLE );

			pDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, TRUE );
			pDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_SRCCOLOR );
			pDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_ZERO);
			pDevice->SetRenderState(D3DRS_BLENDOP, D3DBLENDOP_ADD);
		}
	};


	class PS_VERTEXCOLOR_REVERSE : public CPixelShaderBufferD3D9
	{
	public:
		virtual void Setup( const SPD3DDEVICE& pDevice )
		{
			pDevice->SetTextureStageState( 0, D3DTSS_COLOROP,	D3DTOP_SELECTARG1 );
			pDevice->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_DIFFUSE );
			pDevice->SetTextureStageState( 0, D3DTSS_COLORARG2, D3DTA_DIFFUSE );
			pDevice->SetTextureStageState( 1, D3DTSS_COLOROP,	D3DTOP_DISABLE );

			pDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP,	D3DTOP_SELECTARG1 );
			pDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG1, D3DTA_DIFFUSE );
			pDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG2, D3DTA_DIFFUSE );
			pDevice->SetTextureStageState( 1, D3DTSS_ALPHAOP,	D3DTOP_DISABLE );

			pDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, TRUE );
			pDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_ZERO );
			pDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_INVSRCCOLOR);
			pDevice->SetRenderState(D3DRS_BLENDOP, D3DBLENDOP_ADD);
		}
	};

	class PS_VERTEXCOLOR_MAX : public CPixelShaderBufferD3D9
	{
	public:
		virtual void Setup( const SPD3DDEVICE& pDevice )
		{
			pDevice->SetTextureStageState( 0, D3DTSS_COLOROP,	D3DTOP_SELECTARG1 );
			pDevice->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_DIFFUSE );
			pDevice->SetTextureStageState( 0, D3DTSS_COLORARG2, D3DTA_DIFFUSE );
			pDevice->SetTextureStageState( 1, D3DTSS_COLOROP,	D3DTOP_DISABLE );

			pDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP,	D3DTOP_SELECTARG1 );
			pDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG1, D3DTA_DIFFUSE );
			pDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG2, D3DTA_DIFFUSE );
			pDevice->SetTextureStageState( 1, D3DTSS_ALPHAOP,	D3DTOP_DISABLE );

			pDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, TRUE );
			pDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA );
			pDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_SRCALPHA);
			pDevice->SetRenderState(D3DRS_BLENDOP, D3DBLENDOP_MAX);
		}
	};

	/////////////////////////////////////////////

	//	eNX`ƒ_F̍
	class PS_SPRITE_NORMAL : public CPixelShaderBufferD3D9
	{
	public:
		virtual void Setup( const SPD3DDEVICE& pDevice )
		{
			pDevice->SetTextureStageState( 0, D3DTSS_COLOROP, D3DTOP_MODULATE );
			pDevice->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_TEXTURE );
			pDevice->SetTextureStageState( 0, D3DTSS_COLORARG2, D3DTA_DIFFUSE );
			pDevice->SetTextureStageState( 1, D3DTSS_COLOROP,	D3DTOP_DISABLE );

			pDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP, D3DTOP_MODULATE );
			pDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE );
			pDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG2, D3DTA_DIFFUSE );
			pDevice->SetTextureStageState( 1, D3DTSS_ALPHAOP,	D3DTOP_DISABLE );

			pDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, TRUE );
			pDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA );
			pDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_SRCALPHA);
			pDevice->SetRenderState(D3DRS_BLENDOP, D3DBLENDOP_ADD);
		}
	};


	class PS_SPRITE_ADD : public CPixelShaderBufferD3D9
	{
	public:
		virtual void Setup( const SPD3DDEVICE& pDevice )
		{
			pDevice->SetTextureStageState( 0, D3DTSS_COLOROP,	D3DTOP_MODULATE );
			pDevice->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_TEXTURE );
			pDevice->SetTextureStageState( 0, D3DTSS_COLORARG2, D3DTA_DIFFUSE );
			pDevice->SetTextureStageState( 1, D3DTSS_COLOROP,	D3DTOP_DISABLE );

			pDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP,	D3DTOP_MODULATE );
			pDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE );
			pDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG2, D3DTA_DIFFUSE );
			pDevice->SetTextureStageState( 1, D3DTSS_ALPHAOP,	D3DTOP_DISABLE );

			pDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, TRUE );
			pDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_ONE );
			pDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_SRCALPHA );
			pDevice->SetRenderState(D3DRS_BLENDOP, D3DBLENDOP_ADD);
		}
	};


	class PS_SPRITE_SUB : public CPixelShaderBufferD3D9
	{
	public:
		virtual void Setup( const SPD3DDEVICE& pDevice )
		{
			pDevice->SetTextureStageState( 0, D3DTSS_COLOROP,	D3DTOP_MODULATE );
			pDevice->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_TEXTURE );
			pDevice->SetTextureStageState( 0, D3DTSS_COLORARG2, D3DTA_DIFFUSE );
			pDevice->SetTextureStageState( 1, D3DTSS_COLOROP,	D3DTOP_DISABLE );

			pDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP,	D3DTOP_MODULATE );
			pDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE );
			pDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG2, D3DTA_DIFFUSE );
			pDevice->SetTextureStageState( 1, D3DTSS_ALPHAOP,	D3DTOP_DISABLE );

			pDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, TRUE );
//			pDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA );
			pDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_ONE );
			pDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_SRCALPHA);
			pDevice->SetRenderState(D3DRS_BLENDOP, D3DBLENDOP_REVSUBTRACT);
		}
	};


	class PS_SPRITE_MUL : public CPixelShaderBufferD3D9
	{
	public:
		virtual void Setup( const SPD3DDEVICE& pDevice )
		{
			pDevice->SetTextureStageState( 0, D3DTSS_COLOROP,	D3DTOP_MODULATE );
			pDevice->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_TEXTURE );
			pDevice->SetTextureStageState( 0, D3DTSS_COLORARG2, D3DTA_DIFFUSE );
			pDevice->SetTextureStageState( 1, D3DTSS_COLOROP,	D3DTOP_DISABLE );

			pDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP,	D3DTOP_MODULATE );
			pDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE );
			pDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG2, D3DTA_DIFFUSE );
			pDevice->SetTextureStageState( 1, D3DTSS_ALPHAOP,	D3DTOP_DISABLE );

			pDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, TRUE );
			pDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_SRCCOLOR );
			pDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_ZERO);
			pDevice->SetRenderState(D3DRS_BLENDOP, D3DBLENDOP_ADD);
		}
	};


	class PS_SPRITE_REVERSE : public CPixelShaderBufferD3D9
	{
	public:
		virtual void Setup( const SPD3DDEVICE& pDevice )
		{
			pDevice->SetTextureStageState( 0, D3DTSS_COLOROP,	D3DTOP_MODULATE );
			pDevice->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_TEXTURE );
			pDevice->SetTextureStageState( 0, D3DTSS_COLORARG2, D3DTA_DIFFUSE );
			pDevice->SetTextureStageState( 1, D3DTSS_COLOROP,	D3DTOP_DISABLE );

			pDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP,	D3DTOP_MODULATE );
			pDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE );
			pDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG2, D3DTA_DIFFUSE );
			pDevice->SetTextureStageState( 1, D3DTSS_ALPHAOP,	D3DTOP_DISABLE );

			pDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, TRUE );
			pDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_ZERO );
			pDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_INVSRCCOLOR);
			pDevice->SetRenderState(D3DRS_BLENDOP, D3DBLENDOP_ADD);
		}
	};

	class PS_SPRITE_MAX : public CPixelShaderBufferD3D9
	{
	public:
		virtual void Setup( const SPD3DDEVICE& pDevice )
		{
			pDevice->SetTextureStageState( 0, D3DTSS_COLOROP,	D3DTOP_MODULATE );
			pDevice->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_TEXTURE );
			pDevice->SetTextureStageState( 0, D3DTSS_COLORARG2, D3DTA_DIFFUSE );
			pDevice->SetTextureStageState( 1, D3DTSS_COLOROP,	D3DTOP_DISABLE );

			pDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP,	D3DTOP_MODULATE );
			pDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE );
			pDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG2, D3DTA_DIFFUSE );
			pDevice->SetTextureStageState( 1, D3DTSS_ALPHAOP,	D3DTOP_DISABLE );

			pDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, TRUE );
			pDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA );
			pDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_SRCALPHA);
			pDevice->SetRenderState(D3DRS_BLENDOP, D3DBLENDOP_MAX);
		}
	};


	class PS_SPRITE_NORMAL_VCADD : public CPixelShaderBufferD3D9
	{
	public:
		virtual void Setup( const SPD3DDEVICE& pDevice )
		{
			pDevice->SetTextureStageState( 0, D3DTSS_COLOROP, D3DTOP_ADD );
			pDevice->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_TEXTURE );
			pDevice->SetTextureStageState( 0, D3DTSS_COLORARG2, D3DTA_DIFFUSE );
			pDevice->SetTextureStageState( 1, D3DTSS_COLOROP,	D3DTOP_DISABLE );

			pDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP, D3DTOP_MODULATE );
			pDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE );
			pDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG2, D3DTA_DIFFUSE );
			pDevice->SetTextureStageState( 1, D3DTSS_ALPHAOP,	D3DTOP_DISABLE );

			pDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, TRUE );
			pDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA );
			pDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_SRCALPHA);
			pDevice->SetRenderState(D3DRS_BLENDOP, D3DBLENDOP_ADD);
		}
	};
	class PS_SPRITE_NORMAL_VCSUB : public CPixelShaderBufferD3D9
	{
	public:
		virtual void Setup( const SPD3DDEVICE& pDevice )
		{
			pDevice->SetTextureStageState( 0, D3DTSS_COLOROP, D3DTOP_SUBTRACT );
			pDevice->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_TEXTURE );
			pDevice->SetTextureStageState( 0, D3DTSS_COLORARG2, D3DTA_DIFFUSE );
			pDevice->SetTextureStageState( 1, D3DTSS_COLOROP,	D3DTOP_DISABLE );

			pDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP, D3DTOP_MODULATE );
			pDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE );
			pDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG2, D3DTA_DIFFUSE );
			pDevice->SetTextureStageState( 1, D3DTSS_ALPHAOP,	D3DTOP_DISABLE );

			pDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, TRUE );
			pDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA );
			pDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_SRCALPHA);
			pDevice->SetRenderState(D3DRS_BLENDOP, D3DBLENDOP_ADD);
		}
	};



	//	tHg̕\p
	class PS_FONT_NORMAL : public CPixelShaderBufferD3D9
	{
	public:
		virtual void Setup( const SPD3DDEVICE& pDevice )
		{
			pDevice->SetTextureStageState( 0, D3DTSS_COLOROP,	D3DTOP_ADD );
			pDevice->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_TEXTURE );
			pDevice->SetTextureStageState( 0, D3DTSS_COLORARG2, D3DTA_DIFFUSE );
			pDevice->SetTextureStageState( 1, D3DTSS_COLOROP,	D3DTOP_DISABLE );

			pDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP,	D3DTOP_MODULATE );
			pDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE );
			pDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG2, D3DTA_DIFFUSE );
			pDevice->SetTextureStageState( 1, D3DTSS_ALPHAOP,	D3DTOP_DISABLE );

			pDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, TRUE );
			pDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA );
			pDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_SRCALPHA);
			pDevice->SetRenderState(D3DRS_BLENDOP, D3DBLENDOP_ADD);
		}
	};


	class PS_MODEL_COLOR : public CPixelShaderBufferD3D9
	{
	public:
		virtual void Setup( const SPD3DDEVICE& pDevice )
		{
			pDevice->SetTextureStageState( 0, D3DTSS_COLOROP,	D3DTOP_SELECTARG1 );
			pDevice->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_DIFFUSE );
			pDevice->SetTextureStageState( 0, D3DTSS_COLORARG2, D3DTA_DIFFUSE );
			pDevice->SetTextureStageState( 1, D3DTSS_COLOROP,	D3DTOP_DISABLE );

			pDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP,	D3DTOP_SELECTARG1 );
			pDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG1, D3DTA_DIFFUSE );
			pDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG2, D3DTA_DIFFUSE );
			pDevice->SetTextureStageState( 1, D3DTSS_ALPHAOP,	D3DTOP_DISABLE );

			pDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, TRUE );
			pDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA );
			pDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_SRCALPHA);
			pDevice->SetRenderState(D3DRS_BLENDOP, D3DBLENDOP_ADD);
		}
	};

	class PS_MODEL_TEXTURE : public CPixelShaderBufferD3D9
	{
	public:
		virtual void Setup( const SPD3DDEVICE& pDevice )
		{
			pDevice->SetTextureStageState( 0, D3DTSS_COLOROP,	D3DTOP_SELECTARG1 );
			pDevice->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_TEXTURE );
			pDevice->SetTextureStageState( 0, D3DTSS_COLORARG2, D3DTA_DIFFUSE );
			pDevice->SetTextureStageState( 1, D3DTSS_COLOROP,	D3DTOP_DISABLE );

			pDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP,	D3DTOP_MODULATE );
			pDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE );
			pDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG2, D3DTA_DIFFUSE );
			pDevice->SetTextureStageState( 1, D3DTSS_ALPHAOP,	D3DTOP_DISABLE );

			pDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, TRUE );
			pDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA );
			pDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_SRCALPHA);
			pDevice->SetRenderState(D3DRS_BLENDOP, D3DBLENDOP_ADD);
		}
	};


	class PS_MODELTONE_COLOR : public CPixelShaderBufferD3D9
	{
	public:
		virtual void Setup( const SPD3DDEVICE& pDevice )
		{
			pDevice->SetTextureStageState( 0, D3DTSS_COLOROP,	D3DTOP_SELECTARG1 );
			pDevice->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_DIFFUSE );
			pDevice->SetTextureStageState( 0, D3DTSS_COLORARG2, D3DTA_DIFFUSE );
			pDevice->SetTextureStageState( 1, D3DTSS_COLOROP,	D3DTOP_DISABLE );

			pDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP,	D3DTOP_SELECTARG1 );
			pDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG1, D3DTA_DIFFUSE );
			pDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG2, D3DTA_DIFFUSE );
			pDevice->SetTextureStageState( 1, D3DTSS_ALPHAOP,	D3DTOP_DISABLE );

			pDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, TRUE );
			pDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA );
			pDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_SRCALPHA);
			pDevice->SetRenderState(D3DRS_BLENDOP, D3DBLENDOP_ADD);
		}
	};

	class PS_MODELTONE_TEXTURE : public CPixelShaderBufferD3D9
	{
	public:
		virtual void Setup( const SPD3DDEVICE& pDevice )
		{
			pDevice->SetTextureStageState( 0, D3DTSS_COLOROP,	D3DTOP_MODULATE );
			pDevice->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_TEXTURE );
			pDevice->SetTextureStageState( 0, D3DTSS_COLORARG2, D3DTA_DIFFUSE );

			pDevice->SetTextureStageState( 1, D3DTSS_COLOROP,	D3DTOP_MODULATE );
			pDevice->SetTextureStageState( 1, D3DTSS_COLORARG1, D3DTA_TEXTURE );
			pDevice->SetTextureStageState( 1, D3DTSS_COLORARG2, D3DTA_CURRENT );

			pDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP,	D3DTOP_MODULATE );
			pDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE );
			pDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG2, D3DTA_DIFFUSE );
			pDevice->SetTextureStageState( 1, D3DTSS_ALPHAOP,	D3DTOP_DISABLE );

			pDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, TRUE );
			pDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA );
			pDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_SRCALPHA);
			pDevice->SetRenderState(D3DRS_BLENDOP, D3DBLENDOP_ADD);
		}
	};


	class PS_SPRITE_MASK_NORMAL_ADD : public CPixelShaderBufferD3D9
	{
	public:
		virtual void Setup( const SPD3DDEVICE& pDevice )
		{


			pDevice->SetTextureStageState( 0, D3DTSS_COLOROP,	D3DTOP_MODULATE );
			pDevice->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_TEXTURE );
			pDevice->SetTextureStageState( 0, D3DTSS_COLORARG2, D3DTA_DIFFUSE );

			pDevice->SetTextureStageState( 1, D3DTSS_COLOROP,	D3DTOP_MODULATE );
			pDevice->SetTextureStageState( 1, D3DTSS_COLORARG1, D3DTA_TEXTURE );
			pDevice->SetTextureStageState( 1, D3DTSS_COLORARG2, D3DTA_DIFFUSE );

			pDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP,	D3DTOP_ADD );
			pDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE );
			pDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG2, D3DTA_DIFFUSE );

			pDevice->SetTextureStageState( 1, D3DTSS_ALPHAOP,	D3DTOP_MODULATE );
			pDevice->SetTextureStageState( 1, D3DTSS_ALPHAARG1, D3DTA_TEXTURE );
			pDevice->SetTextureStageState( 1, D3DTSS_ALPHAARG2, D3DTA_CURRENT );

			pDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, TRUE );
			pDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA );
			pDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_SRCALPHA);
			pDevice->SetRenderState(D3DRS_BLENDOP, D3DBLENDOP_ADD);
		}
	};

	class PS_SPRITE_MASK_NORMAL_SUB : public CPixelShaderBufferD3D9
	{
	public:
		virtual void Setup( const SPD3DDEVICE& pDevice )
		{

			pDevice->SetTextureStageState( 0, D3DTSS_COLOROP,	D3DTOP_MODULATE );
			pDevice->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_TEXTURE );
			pDevice->SetTextureStageState( 0, D3DTSS_COLORARG2, D3DTA_DIFFUSE );

			pDevice->SetTextureStageState( 1, D3DTSS_COLOROP,	D3DTOP_MODULATE );
			pDevice->SetTextureStageState( 1, D3DTSS_COLORARG1, D3DTA_TEXTURE );
			pDevice->SetTextureStageState( 1, D3DTSS_COLORARG2, D3DTA_DIFFUSE );

			pDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP,	D3DTOP_SUBTRACT );
			pDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE );
			pDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG2, D3DTA_DIFFUSE );

			pDevice->SetTextureStageState( 1, D3DTSS_ALPHAOP,	D3DTOP_MODULATE );
			pDevice->SetTextureStageState( 1, D3DTSS_ALPHAARG1, D3DTA_TEXTURE );
			pDevice->SetTextureStageState( 1, D3DTSS_ALPHAARG2, D3DTA_CURRENT );

			pDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, TRUE );
			pDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA );
			pDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_SRCALPHA);
			pDevice->SetRenderState(D3DRS_BLENDOP, D3DBLENDOP_ADD);
		}
	};

}

#endif