#include"CVideoCardDriverD3D9.h"
#include"CVertexDeclarationBufferD3D9.h"

#include"../../../../../Auxiliary/Debug/CException.h"
#include"../../../../CResourceNameGenerator.h"

namespace Maid
{

	using namespace VERTEXDECLARATIONNAME;

static const D3DVERTEXELEMENT9 s_DECL_XYZ0NORMAL1[] =
{
    {0,  0, D3DDECLTYPE_FLOAT3,   D3DDECLMETHOD_DEFAULT, D3DDECLUSAGE_POSITION, 0},//  ʒu
    {1,  0, D3DDECLTYPE_FLOAT3,   D3DDECLMETHOD_DEFAULT, D3DDECLUSAGE_NORMAL,   0},//  @
    D3DDECL_END()
};

static const D3DVERTEXELEMENT9 s_DECL_XYZ0NORMAL1TEX2[] =
{
    {0,  0, D3DDECLTYPE_FLOAT3,   D3DDECLMETHOD_DEFAULT, D3DDECLUSAGE_POSITION, 0},//  ʒu
    {1,  0, D3DDECLTYPE_FLOAT3,   D3DDECLMETHOD_DEFAULT, D3DDECLUSAGE_NORMAL,   0},//  @
    {2,  0, D3DDECLTYPE_FLOAT2,   D3DDECLMETHOD_DEFAULT, D3DDECLUSAGE_TEXCOORD, 0},//  eNX`
    D3DDECL_END()
};

SPVERTEXDECLARATIONBUFFER CVideoCardDriverD3D9::CreateVertexDeclarationBuffer( const mstring& Name )
{
	const D3DVERTEXELEMENT9* pDecl = NULL;

	if( Name==GeneratDefault(XYZ0NORMAL1    ) ) { pDecl = s_DECL_XYZ0NORMAL1; }
	ef( Name==GeneratDefault(XYZ0NORMAL1TEX2) ) { pDecl = s_DECL_XYZ0NORMAL1TEX2; }


	MAID_ASSERT( pDecl==NULL, MAIDTEXT("decl`Ă܂") );

	SPD3DVERTEXDECLARATION pBuff;
	{
		IDirect3DVertexDeclaration9* p;
		const HRESULT ret = m_pDevice->CreateVertexDeclaration( pDecl, &p );
		if( FAILED(ret) ) { MAID_THROWEXCEPTION(MAIDTEXT("IDirect3DDevice9::CreateVertexDeclaration()")); }

		pBuff.reset( p );
	}

	return SPVERTEXDECLARATIONBUFFER(new CVertexDeclarationBufferD3D9(pBuff) );
}


}

