#include"CTextureBufferD3D9.h"

namespace Maid
{

CTextureBufferD3D9::CTextureBufferD3D9( IDirect3DTexture9* p )
{
	pTexture.reset( p );

	const int count = pTexture->GetLevelCount();

	MAID_ASSERT( count==0, "T[tFX܂" );

	for( int i=0; i<count; ++i )
	{
		IDirect3DSurface9* pp;
		pTexture->GetSurfaceLevel( i, &pp );

		Surface.push_back( CSurfaceBufferD3D9( pp ) );
	}

	Size	= Surface[0].GetSize();
	Format	= Surface[0].GetPixelFormat();
}


SIZE2DI CTextureBufferD3D9::GetSize() const
{
	MAID_ASSERT( pTexture.get()==NULL, "Ă܂" );
	return Size;
}

PIXELFORMAT CTextureBufferD3D9::GetPixelFormat() const
{
	MAID_ASSERT( pTexture.get()==NULL, "Ă܂" );
	return Format;
}

int CTextureBufferD3D9::GetSurfaceLevel() const
{
	MAID_ASSERT( pTexture.get()==NULL, "Ă܂" );
	return (int)Surface.size();
}

ISurfaceBuffer& CTextureBufferD3D9::GetSurface( int Level )
{
	MAID_ASSERT( pTexture.get()==NULL, "Ă܂" );
	MAID_ASSERT( !(Level<(int)Surface.size()), "͈͂𒴂Ă܂" );

	return Surface[Level];
}



}
/*
#include"../../../../../Setup/CompileMode.h"
#include"../../CTextureBuffer.h"

#include"D3D9Include.h"


	class CTextureBufferD3D9 : public ITextureBuffer
	{
	public:
		virtual SIZE2DI GetSize() const;
		virtual PIXELFORMAT GetPixelFormat() const;
		virtual int GetSurfaceLevel() const;
		virtual ISurfaceBuffer& GetSurface( int Level );

		SPD3DTEXUREBUFFER					pTexture;
		MySTL::vector<SPD3DSURFACEBUFFER>	pSurface;
	};
}

#endif
*/
