#include"CSurfaceBufferD3D9.h"
#include"../../CSurfaceBufferInfoTemplate.h"


namespace Maid
{

CSurfaceBufferD3D9::CSurfaceBufferD3D9()
{

}


CSurfaceBufferD3D9::CSurfaceBufferD3D9( IDirect3DSurface9* pCom )
{
	pSurface.reset(pCom);
	pSurface->GetDesc( &Desc );
}

SIZE2DI CSurfaceBufferD3D9::GetSize() const
{
	MAID_ASSERT( pSurface.get()==NULL, "Ă܂" );
	return SIZE2DI( Desc.Width, Desc.Height );
}

PIXELFORMAT CSurfaceBufferD3D9::GetPixelFormat() const
{
	MAID_ASSERT( pSurface.get()==NULL, "Ă܂" );
	return D3DFORMATtoPIXELFORMAT( Desc.Format );
}

void CSurfaceBufferD3D9::Lock( SPSURFACEBUFFERINFO& info )
{
	MAID_ASSERT( pSurface.get()==NULL, "Ă܂" );

	SIZE2DI size = GetSize();
	PIXELFORMAT fmt = GetPixelFormat();

	D3DLOCKED_RECT rc;

	const HRESULT ret =	pSurface->LockRect( &rc, NULL, 0 );
	if( FAILED(ret) ) { MAID_THROWEXCEPTION( MAIDTEXT("IDirect3DSurface9::LockRect()") ); }

	info.reset(	new ISurfaceBufferInfoNormal(
		rc.pBits, NULL, size.w, size.h, fmt, rc.Pitch ) );
}

void CSurfaceBufferD3D9::Unlock()
{
	MAID_ASSERT( pSurface.get()==NULL, "Ă܂" );
	const HRESULT ret =	pSurface->UnlockRect();
	if( FAILED(ret) ) { MAID_THROWEXCEPTION( MAIDTEXT("IDirect3DSurface9::UnlockRect()") ); }
}

}