#include"CSurfaceDIB.h"
#include"../CSurfaceBufferInfoTemplate.h"
#include"../../../../Auxiliary/Debug/CWarning.h"
#include"../../../../Auxiliary/Debug/CAssert.h"
#include"../../../../Auxiliary/Debug/CException.h"


namespace Maid
{

/*!
 	}XNrbg̐ݒ
 
 	@param	Header	[ o]	ݒ
 	@param	Alpha	[i ]	rbg
 	@param	Red		[i ]	ԃrbg
 	@param	Green	[i ]	΃rbg
 	@param	Blue	[i ]	rbg
 */
inline void SetMask( BITMAPV4HEADER& Header, DWORD Alpha, DWORD Red, DWORD Green, DWORD Blue )
{
	Header.bV4AlphaMask = Alpha;
	Header.bV4RedMask   = Red;
	Header.bV4GreenMask = Green;
	Header.bV4BlueMask  = Blue;
}

/*!
 	@class	CSurfaceDIB CSurfaceDIB.h
 	@brief	`敽ʃNX DIB Ver.
 */

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! RXgN^
/*!
 */
CSurfaceDIB::CSurfaceDIB() : m_hDIB(NULL), m_pPlane(NULL)
{
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! fXgN^
/*!
 */
CSurfaceDIB::~CSurfaceDIB()
{
	Destory();
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! T[tFX̉̎擾
/*!
 	Ȃǂ ISurfaceBuffer::GetSize() QƂ邱
 */
SIZE2DI CSurfaceDIB::GetSize() const
{
	MAID_ASSERT( m_hDIB==NULL, "܂쐬Ă܂" );
	return m_Size;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! T[tFX̃sNZtH[}bg̎擾
/*!
 	Ȃǂ ISurfaceBuffer::GetPixelFormat() QƂ邱
 */
PIXELFORMAT CSurfaceDIB::GetPixelFormat() const
{
	MAID_ASSERT( m_hDIB==NULL, "܂쐬Ă܂" );
	return m_PixelFormat;
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! T[tFX̍쐬
/*!
 	Ȃǂ ISurfaceBuffer::CreateSurface() QƂ邱
 */
void CSurfaceDIB::CreateBuffer( int Width, int Height, PIXELFORMAT Format )
{
	//	DIB̉͂S̔{łȂ΍쐬łȂ
	const int w = (Width+3)&~3;
	BITMAPINFOHEADER dib;

	ZERO( &dib, sizeof(dib) );
	dib.biSize = sizeof(dib);
	dib.biWidth = w;
	dib.biHeight = -(int)Height;
	dib.biPlanes = 1;
	dib.biBitCount = 8*GetPixelBPP(Format)/8;


/*
	BITMAPV4HEADER Header;

	ZeroMemory(&Header, sizeof(Header));
	Header.bV4Size = sizeof(BITMAPV4HEADER);
	Header.bV4Width = w;
	Header.bV4Height = -short(Height);
	Header.bV4Planes = 1;
	Header.bV4BitCount = GetPixelBPP(eFormat);
	Header.bV4V4Compression = BI_BITFIELDS;
	Header.bV4SizeImage = 0;
	Header.bV4XPelsPerMeter = 0;
	Header.bV4YPelsPerMeter = 0;
	Header.bV4ClrUsed = 0;
	Header.bV4ClrImportant = 0;

	//	sNZtH[}bgɂ}XN𐶐
	switch( eFormat )
	{
	case PIXELFORMAT_ARGB8888:  { SetMask( Header, 0xFF000000, 0x00FF0000, 0x0000FF00, 0x000000FF ); }break;
	case PIXELFORMAT_XRGB8888:  { SetMask( Header, 0x00000000, 0x00FF0000, 0x0000FF00, 0x000000FF ); }break;
	case PIXELFORMAT_RGB888:	{ SetMask( Header, 0x00000000, 0x00FF0000, 0x0000FF00, 0x000000FF ); }break;
	case PIXELFORMAT_ARGB4444:	{ SetMask( Header, 0x0000F000, 0x00000F00, 0x000000F0, 0x0000000F ); }break;
	case PIXELFORMAT_ARGB1555:	{ SetMask( Header, 0x00008000, 0x00007C00, 0x000003E0, 0x0000001F ); }break;
	case PIXELFORMAT_XRGB1555:	{ SetMask( Header, 0x00000000, 0x00007C00, 0x000003E0, 0x0000001F ); }break;
	case PIXELFORMAT_RGB565:	{ SetMask( Header, 0x00000000, 0x0000F800, 0x000007E0, 0x0000001F ); }break;
		//	pbg͖T|[g
	}
*/
	HDC hDC = ::CreateCompatibleDC(NULL);

	if( hDC==NULL ) { MAID_THROWEXCEPTION( MAIDTEXT("hDC==NULL") ); }
	m_hDIB = CreateDIBSection( hDC, (BITMAPINFO *)&dib, DIB_RGB_COLORS, (void **)&m_pPlane, NULL, 0 );
	::DeleteDC(hDC);
	if( m_hDIB==NULL ) { MAID_THROWEXCEPTION( MAIDTEXT("DIBmۂɎs") ); }


	m_Size = SIZE2DI(Width,Height);
	m_PixelFormat = Format;
	m_Pitch = w * GetPixelBPP(Format)/8;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! T[tFX̔j
/*!
 	Ȃǂ ISurfaceBuffer::Destory() QƂ邱
 */
void CSurfaceDIB::Destory()
{
	::DeleteObject(m_hDIB);
	m_hDIB = NULL;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! T[tFX̃bN
/*!
 	Ȃǂ ISurfaceBuffer::Lock() QƂ邱
 */
void CSurfaceDIB::Lock( SPSURFACEBUFFERINFO& info )
{
	MAID_ASSERT( m_hDIB==NULL, "܂쐬Ă܂" );

	info.reset( new ISurfaceBufferInfoNormal( m_pPlane, NULL, 
		m_Size.w, m_Size.h, m_PixelFormat, m_Pitch ) );
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! T[tFX̃AbN
/*!
 	Ȃǂ ISurfaceBuffer::Unlock() QƂ邱
 */
void CSurfaceDIB::Unlock()
{
	//	Ȃ
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! HBITMAP ̎擾
/*!
 	@return HBITMAP
 */
HBITMAP CSurfaceDIB::GetHBITMAP() const
{
	MAID_ASSERT( m_hDIB==NULL, "܂쐬Ă܂" );
	return m_hDIB;
}

}

