/*!
 	@file
 	@brief	tHgǗĂx[XNX
 */
#ifndef CFontDriverWindows_h
#define CFontDriverWindows_h

#include"../../../../Setup/CompileMode.h"
#include"../CFontDriver.h"


#include"../../../../Setup/Win32.h"
#include"../CSurfaceBufferMemory.h"

namespace Maid
{
	class CFontDriverWindows : public IFontDriver
	{
	public:
		virtual SPFONT Create( int FontNo, int FontW, int FontH, bool IsAntialias, bool IsBold, bool IsItalic ) const;
		virtual SPFONT Create( const mstring& FontName, int FontW, int FontH, bool IsAntialias, bool IsBold, bool IsItalic ) const;
		virtual int GetFontNum() const;
		virtual mstring GetFontName( int FontNo ) const;
		virtual SPSURFACEBUFFER Rasterize( const SPFONT& pFont, unt32 FontCode ) const;

	private:
		void RasterizeMemory( SPSURFACEBUFFERMEMORY& pDst, const SPFONT& pFont, unt32 FontCode ) const;
		unt08 Antialias4X( int x, int y, SPSURFACEBUFFERINFO& pInfo )const;

	private:
		HFONT CreateFont( const mstring& FontName, int Width, int Height, bool IsBold, bool IsItalic )const;

	};

}

#endif
