#ifndef CVideoCardDriver_h
#define CVideoCardDriver_h

#include"../../../Setup/CompileMode.h"
#include"../../../Auxiliary/Debug/CException.h"
#include"../../../template/Mathematics.h"
#include"../../Color.h"
#include"../../CSurfaceInfo.h"
#include"CSurfaceBuffer.h"
#include"CSurfaceBufferMemory.h"
#include"CVertexBuffer.h"
#include"CIndexBuffer.h"
#include"CTextureBuffer.h"
#include"CTextureBufferMemory.h"
#include"CVertexShaderBuffer.h"
#include"CPixelShaderBuffer.h"
#include"CVertexDeclarationBuffer.h"
#include<boost/smart_ptr.hpp>
#include<vector>

namespace Maid
{
	/*!	
		@brief	foCXXgƂɔłO
	\n			E IVideoCardDriver::Reset() ŕA݂
	*/
	class CDeviceLost : public CException
	{

	};

	/*!	
		@class	IVideoCardDriver CVideoCardDriver.h
		@brief	rfIhCo
	\n			hCoɂĂ͂ł邱ƁAłȂƂ܂
	\n			łȂꍇ̓G[ôł͂ȂAؗɃX[悤ɂĂ
	\n			^CG[Nꍇ CException 𓊂邱
	*/

	class IVideoCardDriver
	{
	public:
		struct SCREENMODE
		{
			enum TYPE
			{
				TYPE_FULL16=0,
				TYPE_FULL32,
				TYPE_WINDOW,
			};

			TYPE	Mode;
			SIZE2DI Size;
			int		RefreshRate;
			bool	IsSoftTnL;
			bool	IsWaitVSync;
			bool	IsAspectLock;
		};


		virtual ~IVideoCardDriver(){};

		/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
		//! hCȍ
		/*!
			@param	mode	[i ]	ė~𑜓x

			@exception CException Ɏsꍇ
		 */
		virtual void Initialize( const SCREENMODE& mode )=0;


		/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
		//! XN[[h̕ύX
		/*!
			foCXXgƂĂ΂܂

			@param	mode	[i ]	炵𑜓x

			@exception CException Ɏsꍇ
		 */
		virtual void Reset( const SCREENMODE& mode )=0;

		virtual void Restore()=0;

		/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
		//! hCo̊J
		/*!
			@exception CException JɎsꍇ
		 */
		virtual void Finalize()=0;

		enum DEVICESTATE
		{
			DEVICESTATE_OK,
			DEVICESTATE_NOTRESET,
			DEVICESTATE_LOST,
		};
		virtual DEVICESTATE TestCooperativeLevel()=0;


		/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
		//! tgobt@ɍXV
		/*!
			@exception CDeviceLost	foCXXgꍇ
			@exception CException	^CG[ɂꍇ
		 */
		virtual void Flip()=0;

		/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
		//! T[tFXobt@̍쐬
		/*!
			@param	size	[i ]	eNX`̑傫
			@param	fmt		[i ]	sNZtH[}bg

			@return	쐬ꂽT[tFXobt@
		 */
		virtual SPSURFACEBUFFER CreateSurface( const SIZE2DI& size, PIXELFORMAT fmt )=0;


		/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
		//! eNX`obt@̍쐬
		/*!
			@param	buffer	[i ]	ɍeNX`obt@
									sNZeRs[܂
									~bv}bvł邩͓

			@return	쐬ꂽeNX`obt@
		 */
		virtual SPTEXTUREBUFFER CreateTextureBuffer( const CTextureBufferMemory& buffer )=0;


		/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
		//! RenderTargeteNX`obt@̍쐬
		/*!
			@param	size	[i ]	eNX`̑傫
			@param	fmt	[i ]	sNZtH[}bg

			@return	쐬ꂽeNX`obt@
		 */
		virtual SPTEXTUREBUFFER CreateRTTextureBuffer( const SIZE2DI& size, PIXELFORMAT fmt )=0;


		/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
		//! CfbNXobt@̍쐬
		/*!
			@param	data	[i ]	CfbNXf[^
			@param	Format	[i ]	PCfbNX̃oCg

			@return	쐬ꂽCfbNXobt@
		 */
		virtual SPINDEXBUFFER CreateIndexBuffer( const MySTL::vector<unt08>& data, int Format )=0;

		/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
		//! _obt@̍쐬
		/*!
			@param	data	[i ]	_f[^
			@param	Format	[i ]	_tH[}bg

			@return	쐬ꂽ_obt@
		 */
		virtual SPVERTEXBUFFER CreateVertexBuffer( const MySTL::vector<unt08>& data, VERTEXFORMAT Format )=0;

		enum SHADERCOMPILE
		{
			SHADERCOMPILE_COPY,		//!<	RpĈ܂܃Rs[
			SHADERCOMPILE_ASSEMBLE,	//!<	AZu
			SHADERCOMPILE_COMPILE,	//!<	RpC
		};

		/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
		//! hCoŗpӂĂo[ebNXVF[_[̍쐬
		/*!
			@param	Name	[i ]	ftHg

			@return	쐬ꂽo[ebNXVF[_[
		 */
		virtual SPVERTEXSHADERBUFFER CreateVertexShader( const mstring& Name )=0;


		/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
		//! Q[Ǝ̃o[ebNXVF[_[̍쐬
		/*!
			@param	Code	[i ]	R[h
			@param	type	[i ]	RpC

			@return	쐬ꂽo[ebNXVF[_[
		 */
		virtual SPVERTEXSHADERBUFFER CreateVertexShader( const MySTL::vector<unt08>& Code, SHADERCOMPILE type )=0;




		/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
		//! hCoŗpӂĂsNZVF[_[̍쐬
		/*!
			@param	Name	[i ]	ftHg

			@return	쐬ꂽsNZVF[_[
		 */
		virtual SPPIXELSHADERBUFFER CreatePixelShader( const mstring& Name )=0;


		/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
		//! Q[Ǝ̃sNZVF[_[̍쐬
		/*!
			@param	Code	[i ]	R[h
			@param	type	[i ]	RpC

			@return	쐬ꂽsNZVF[_[
		 */
		virtual SPPIXELSHADERBUFFER CreatePixelShader( const MySTL::vector<unt08>& Code, SHADERCOMPILE type )=0;


		/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
		//! hCoŗpӂĂ钸_`̍쐬
		/*!
			@param	Name	[i ]	ftHg

			@return	쐬ꂽ_`
		 */
		virtual SPVERTEXDECLARATIONBUFFER CreateVertexDeclarationBuffer( const mstring& Name )=0;


		virtual void SetRenderTarget( const ISurfaceBuffer* pBuffer )=0;
		virtual void ResetRenderTarget()=0;

		virtual void SetDepthStencil( const ISurfaceBuffer* pBuffer )=0;
		virtual void ResetDepthStencil()=0;

		/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
		//! eNX`obt@̊J
		/*!
			@param	stage	[i ]	ݒ肷Xe[W
		 */
		virtual void UnsetTextureBuffer( int stage )=0;

		/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
		//! eNX`obt@̃Zbg
		/*!
			@param	pBuffer	[i ]	ݒ肷obt@
			@param	stage	[i ]	ݒ肷Xe[W
		 */
		virtual void SetTextureBuffer( const SPTEXTUREBUFFER& pBuffer, int stage )=0;

		/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
		//! CfbNXobt@̃Zbg
		/*!
			@param	pBuffer	[i ]	ݒ肷CfbNX
		 */
		virtual void SetIndexBuffer( const SPINDEXBUFFER& pBuffer )=0;

		/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
		//! _obt@̃Zbg
		/*!
			@param	pBuffer	[i ]	ݒ肷obt@
		 */
		virtual void SetVertexBuffer( const SPVERTEXBUFFER& pBuffer, int pos )=0;

		/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
		//! o[ebNXVF[_[̃Zbg
		/*!
			@param	pShader	[i ]	ݒ肷VF[_[
		 */
		virtual void SetVertexShader( const SPVERTEXSHADERBUFFER& pShader )=0;

		/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
		//! sNZVF[_[̃Zbg
		/*!
			@param	pShader	[i ]	ݒ肷VF[_[
		 */
		virtual void SetPixelShader( const SPPIXELSHADERBUFFER& pShader )=0;


		/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
		//! _`̃Zbg
		/*!
			@param	pDecl	[i ]	ݒ肷`
		 */
		virtual void SetVertexDeclaration( const SPVERTEXDECLARATIONBUFFER& pDecl )=0;

		virtual void SetVertexShaderConstF( int pos, const VECTOR4DF& vec )=0;

		virtual void SetViewPort( const RECT2DI& screen, float MinZ, float MaxZ ) = 0;

		virtual void CopySurface( const SPSURFACEBUFFER& pSrc, SPSURFACEBUFFERMEMORY& pDst )=0;

		virtual mstring GetVideoInfo()=0;


		enum RENDERSTATE
		{
			RENDERSTATE_CULLINGMODE,
			RENDERSTATE_ZWRITEENABLE,
			RENDERSTATE_ZWRITEFUNC,
			RENDERSTATE_ZTESTENABLE,
		};

		enum CULLINGMODE
		{
			CULLINGMODE_NONE=0,
			CULLINGMODE_LEFT,	//!<	vɃJO
			CULLINGMODE_RIGHT	//!<	vɃJO
		};

		enum STATEBOOL
		{
			STATE_TRUE,
			STATE_FALSE,
		};

		enum CMPTYPE
		{
			CMPTYPE_NEVER		= 1,	//!<	ɒʂ
			CMPTYPE_LESS		= 2,	//!<	o >  n
			CMPTYPE_EQUAL		= 3,	//!<	o == n
			CMPTYPE_LESSEQUAL	= 4,	//!<	o >= n
			CMPTYPE_GREATER		= 5,	//!<	o <  n
			CMPTYPE_NOTEQUAL	= 6,	//!<	o != n
			CMPTYPE_GREATEREQUAL= 7,	//!<	o <= n
			CMPTYPE_ALWAYS		= 8,	//!<	Ƀ_
		};

		virtual void SetRenderState( RENDERSTATE state, unt value )=0;


		enum SAMPLERSTATE
		{
			SAMPLERSTATE_MAGFILTER,
			SAMPLERSTATE_MINFILTER,
			SAMPLERSTATE_TADDRESSU,
			SAMPLERSTATE_TADDRESSV,
		};

		enum FILTERTYPE
		{
			FILTERTYPE_POINT,
			FILTERTYPE_LINEAR,
			FILTERTYPE_ANISOTROPIC,
		};

		enum TEXTUREADDRESS
		{
			TEXTUREADDRESS_WRAP,
			TEXTUREADDRESS_MIRROR,
			TEXTUREADDRESS_CLAMP,
		};


		virtual void SetSamplerState( int Stage, SAMPLERSTATE state, unt value )=0;

		/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
		//! _O̊Jn
		/*!
		 */
		virtual void BeginScene()=0;
		/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
		//! _ȌI
		/*!
		 */
		virtual void EndScene()=0;

		/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
		//! ݂ RenderTarget hԂ
		/*!
			@param	Color	[i ]	hԂF
		 */
		virtual void ClearColor( const COLOR_R08G08B08I& Color )=0;

		/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
		//! ݂ Zobt@ hԂ
		/*!
			@param	val	[i ]	hԂl
		 */
		virtual void ClearZ( float val )=0;

		enum PRIMITIVE
		{
			PRIMITIVE_POINTLIST=0,
			PRIMITIVE_LINELIST,
			PRIMITIVE_LINESTRIP,
			PRIMITIVE_TRIANGLELIST,
			PRIMITIVE_TRIANGLESTRIP,
			PRIMITIVE_TRIANGLEFAN,
		};

		/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
		//! |S̕`
		/*!
			@param	prim			[i ]	`̌`
			@param	StartVertex		[i ]	`Jn钸_ԍ
			@param	PrimitiveCount	[i ]	`悷鐔
		 */
		virtual void DrawPrimitive( PRIMITIVE prim, unt StartVertex, unt PrimitiveCount )=0;

		/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
		//! |S̕`
		/*!
			@param	prim			[i ]	`̌`
			@param	pVertex			[i ]	`Jn钸_
			@param	Stride			[i ]	P_̑傫
			@param	PrimitiveCount	[i ]	`悷鐔
		 */
		virtual void DrawPrimitiveUP( PRIMITIVE prim, const void* pVertex, unt Stride, unt PrimitiveCount )=0;

		/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
		//! |S̕`
		/*!
			@param	prim			[i ]	`̌`
			@param	BaseVertexOffset[i ]	VertexBuffer MinIndex ̃ItZbg
			@param	MinIndex		[i ]	CfbNX̍ŏ̒l
			@param	NumVertices		[i ]	ĂяoŎgp钸_̐
			@param	StartIndex		[i ]	ڂ̃CfbNX`Jn邩H
			@param	PrimitiveCount	[i ]	`悷鐔
		 */
		virtual void DrawIndexedPrimitive( PRIMITIVE prim, int BaseVertexOffset, unt MinIndex, unt NumVertices, unt StartIndex, unt PrimitiveCount )=0;


		virtual void DrawIndexPrimitiveUP( PRIMITIVE prim, int MinIndex, int NumVertices, const void* pVertex, int VertexSize, int PrimitiveCount, const void* pIndex, int IndexSize  )=0;

	private:

	};

	typedef	boost::shared_ptr<IVideoCardDriver>	SPVIDEOCARDDRIVER;

}


#endif