/*!
 	@file
 	@brief	eNX`obt@I Ver.
 */

#ifndef CTextureBufferMemory_h
#define CTextureBufferMemory_h

#include"../../../Setup/CompileMode.h"
#include"CTextureBuffer.h"
#include"CSurfaceBufferMemory.h"


#include<boost/smart_ptr.hpp>

namespace Maid
{
	class CTextureBufferMemory : public ITextureBuffer
	{
	public:
		CTextureBufferMemory();
		~CTextureBufferMemory();

		virtual SIZE2DI GetSize() const;
		virtual PIXELFORMAT GetPixelFormat() const;
		virtual int GetSurfaceLevel() const;
		virtual ISurfaceBuffer& GetSurface( int Level );

		void Create( const SIZE2DI& size, PIXELFORMAT fmt, int level=1 );
		void Destroy();

		CSurfaceBufferMemory& GetSurfaceEx( int Level );
		void SetReverseSurface( bool IsReverse );

	private:
		MySTL::vector<CSurfaceBufferMemory>	m_Surface;
	};
}

#endif

