
#include"CSurfaceBuffer.h"
#include"../../../auxiliary/Debug/CAssert.h"


namespace Maid
{

void* ISurfaceBufferInfo::GetPixelPtr( int PosX, int PosY ) const
{
	MAID_ASSERT( PosX<0, "XWsł " << PosX );
	MAID_ASSERT( PosY<0, "YWsł " << PosY );

	unt08* p = (unt08*)GetLinePtr( PosY );

	return p + PosX * GetPixelBPP(GetPixelFormat())/8;
}

COLOR_A08R08G08B08I ISurfaceBufferInfo::GetPixel( int x, int y )
{
	COLOR_A08R08G08B08I ret;

	void* p = GetPixelPtr(x,y);

	switch( GetPixelFormat() )
	{
	case PIXELFORMAT_A08R08G08B08I:	{ ret = *(COLOR_A08R08G08B08I*)p;}break;
	case PIXELFORMAT_X08R08G08B08I:	{ ret = *(COLOR_X08R08G08B08I*)p;}break;
	case PIXELFORMAT_R08G08B08I:	{ ret = *(COLOR_R08G08B08I*  )p;}break;
	case PIXELFORMAT_A04R04G04B04I:	{ ret = *(COLOR_A04R04G04B04I*)p;}break;
	case PIXELFORMAT_R05G06B05I:	{ ret = *(COLOR_R05G06B05I*  )p;}break;
	case PIXELFORMAT_X01R05G05B05I:	{ ret = *(COLOR_X01R05G05B05I*)p;}break;
	case PIXELFORMAT_A01R05G05B05I:	{ ret = *(COLOR_A01R05G05B05I*)p;}break;

	case PIXELFORMAT_P08X08R08G08B08I:
	case PIXELFORMAT_P08A08R08G08B08I:
	default:
		{
			MAID_ASSERT( true, "Ή" );
		}break;

	}

	return ret;
}

void ISurfaceBufferInfo::SetPixel( int x, int y, const COLOR_A08R08G08B08I& col )
{
	void* p = GetPixelPtr(x,y);

	switch( GetPixelFormat() )
	{
	case PIXELFORMAT_A08R08G08B08I:	{ *(COLOR_A08R08G08B08I*)p = col; }break;
	case PIXELFORMAT_X08R08G08B08I:	{ *(COLOR_X08R08G08B08I*)p = col; }break;
	case PIXELFORMAT_R08G08B08I:	{ *(COLOR_R08G08B08I*)p    = col; }break;
	case PIXELFORMAT_A04R04G04B04I:	{ *(COLOR_A04R04G04B04I*)p = col; }break;
	case PIXELFORMAT_R05G06B05I:	{ *(COLOR_R05G06B05I*)p    = col; }break;
	case PIXELFORMAT_X01R05G05B05I:	{ *(COLOR_X01R05G05B05I*)p = col; }break;
	case PIXELFORMAT_A01R05G05B05I:	{ *(COLOR_A01R05G05B05I*)p = col; }break;

	case PIXELFORMAT_P08X08R08G08B08I:
	case PIXELFORMAT_P08A08R08G08B08I:
	default:
		{
			MAID_ASSERT( true, "Ή" );
		}break;
	}

}

}

