#include"TraceMode.h"
#include"CGraphicCore.h"
#include"../../Auxiliary/debug/cwarning.h"
#include"../../Auxiliary/debug/CTrace.h"

#include"../CRenderMessageImpl1.h"
#include"../CRenderMessageImpl2.h"


namespace Maid
{

void CGraphicCore::SwapRenderMessage( RENDERMESSAGEQUE& mess )
{
	m_RenderQue.swap(mess);
}

void CGraphicCore::ScreenTest()
{
	const IVideoCardDriver::DEVICESTATE state = m_pDriver->TestCooperativeLevel();

	switch( state )
	{
	case IVideoCardDriver::DEVICESTATE_OK: { return; }break;
	case IVideoCardDriver::DEVICESTATE_NOTRESET:  { m_pDriver->Restore(); }break;
	case IVideoCardDriver::DEVICESTATE_LOST: { }break;
	}
}


void CGraphicCore::DrawFrame( RETURNMESSAGEQUE& Return )
{
	ScreenTest();

	{
		m_pDriver->BeginScene();
		m_pDriver->ClearColor( COLOR_R08G08B08I(0x00,0x00,0x00) );
		m_pDriver->ClearZ( 1.0f );

		const RENDERMESSAGEQUE& MessList = m_RenderQue;
		for( int i=0; i<(int)MessList.size(); ++i )
		{
			ExecuteRenderMessage( MessList[i], Return );
		}

		m_pDriver->EndScene();
		m_pDriver->Flip();
	}

	m_RenderQue.resize(0);
}




}