#ifndef COLOR_X01R05G05B05I_h
#define COLOR_X01R05G05B05I_h

/*!
 	@file
 	@brief	PsNZ킷NXS
\n			XRGB1555 tH[}bg Ver.
*/

#include"../../Setup/CompileMode.h"
#include"../../Auxiliary/Macro.h"

#include"PixelConvertFunction.h"

namespace Maid
{
	/*!
	 	@class	COLOR_X01R05G05B05I COLOR_X01R05G05B05I.h
	 	@brief	At@ȂPUrbgsNZ
	 */
	class COLOR_X01R05G05B05I
	{
	public:
		COLOR_X01R05G05B05I(){}	//!<	RXgN^
		COLOR_X01R05G05B05I( unt08 a, unt08 r, unt08 g, unt08 b ){ SetRGB( r, g, b ); }	//!<	RXgN^
		template <class COLOR>
		COLOR_X01R05G05B05I( const COLOR& Col ){  SetRGB( Col.GetR(), Col.GetG(), Col.GetB() );  }	//!<	RXgN^


		unt08 GetA() const	{ return 0xFF;		}	//!<	At@̎擾
		unt08 GetR() const	{ return PIXELCONVERT05_08((m_RGB&0x7C00)>>10);	}	//!<	Ԑ̎擾
		unt08 GetG() const	{ return PIXELCONVERT05_08((m_RGB&0x03E0)>> 5);	}	//!<	ΐ̎擾
		unt08 GetB() const	{ return PIXELCONVERT05_08((m_RGB&0x001F)<< 3);	}	//!<	̎擾

		operator unt16() const { return m_RGB; }	//!<	ꊇϊ

		void SetA( unt08 a )	{ }															//!<	At@̐ݒ
		void SetR( unt08 r )	{ m_RGB = (m_RGB&~0x7C00)|(PIXELCONVERT08_05(r)<<10);	}	//!<	Ԑ̐ݒ
		void SetG( unt08 g )	{ m_RGB = (m_RGB&~0x03E0)|(PIXELCONVERT08_05(g)<< 5);	}	//!<	ΐ̐ݒ
		void SetB( unt08 b )	{ m_RGB = (m_RGB&~0x001F)|(PIXELCONVERT08_05(b)<< 0);	}	//!<	̐ݒ

		void SetRGB( unt08 r, unt08 g, unt08 b )	//!<	ɐݒ
		{
			SetR( r );
			SetG( g );
			SetB( b );
		}

		//!	ႤsNZtH[}bgƂ̃Rs[
		template <class PIXEL>
		COLOR_X01R05G05B05I& operator = (const PIXEL &src)
		{
			SetRGB(src.GetR(),src.GetG(),src.GetB());
			return *this;
		}

		//!	sNZtH[}bgƂ̃Rs[
		COLOR_X01R05G05B05I& operator = (const COLOR_X01R05G05B05I& src)
		{
			m_RGB = src.m_RGB;
			return *this;
		}

	private:
		unt16 m_RGB;
	};


}

#endif
