#ifndef COLOR_R32G32B32F_h
#define COLOR_R32G32B32F_h

/*!
 	@file
 	@brief	PsNZ킷NX
\n			RGB ꂼ float tH[}bg Ver.
 */
#include"../../Setup/CompileMode.h"
#include"../../Auxiliary/Macro.h"
#include"COLOR_A08R08G08B08I.h"

namespace Maid
{
	/*!
	 *	\class	COLOR_R32G32B32F COLOR_R32G32B32F.h
	 *	\brief	RGB ꂼ float32rbgJ[
	\n			J[̃NXƂ͌݊܂
	 */
	class COLOR_R32G32B32F
	{
	public:
		COLOR_R32G32B32F(){}	//!<	RXgN^
		COLOR_R32G32B32F( float32 r, float32 g, float32 b )
			: m_Red(r), m_Green(g), m_Blue(b) {}	//!<	RXgN^

		template <class COLOR>
		COLOR_R32G32B32F( const COLOR& Col ){  Convert( Col );  }	//!<	RXgN^
		COLOR_R32G32B32F( const COLOR_R32G32B32F& Col )
			: m_Red(Col.m_Red), m_Green(Col.m_Green), m_Blue(Col.m_Blue) {}	//!<	RXgN^

		float32 GetA() const	{ return 1.0f;		}	//!<	At@̎擾
		float32 GetR() const	{ return m_Red;		}	//!<	Ԑ̎擾
		float32 GetG() const	{ return m_Green;	}	//!<	ΐ̎擾
		float32 GetB() const	{ return m_Blue;	}	//!<	̎擾

		void SetA( float32 a )	{ 	}				//!<	At@̐ݒ
		void SetR( float32 r )	{ m_Red   = r;	}	//!<	Ԑ̐ݒ
		void SetG( float32 g )	{ m_Green = g;	}	//!<	ΐ̐ݒ
		void SetB( float32 b )	{ m_Blue  = b;	}	//!<	̐ݒ

		//!	ႤsNZtH[}bgƂ̃Rs[
		template <class PIXEL>
		COLOR_R32G32B32F& operator = (const PIXEL &src)
		{
			Convert(src);
			return *this;
		}

		//!	sNZtH[}bgƂ̃Rs[
		COLOR_R32G32B32F& operator = (const COLOR_R32G32B32F& src)
		{
			m_Red   = src.m_Red;
			m_Green = src.m_Green;
			m_Blue  = src.m_Blue;
			return *this;
		}

		template <class PIXEL>
		void Convert( const PIXEL& Color )
		{
			m_Red   = float32(Color.GetR()) / 255.0f;
			m_Green = float32(Color.GetG()) / 255.0f;
			m_Blue  = float32(Color.GetB()) / 255.0f;
		}

		COLOR_A08R08G08B08I ConvertA08R08G08B08I() const
		{
			return COLOR_A08R08G08B08I(	255,
									int32(m_Red  *255.0f+0.5f),
									int32(m_Green*255.0f+0.5f),
									int32(m_Blue *255.0f+0.5f)
										);
		}

	private:
		float32 m_Red;		//	ԐilF 0.0-1.0)
		float32 m_Green;	//	ΐilF 0.0-1.0)
		float32 m_Blue;		//	ilF 0.0-1.0)
	};
}

#endif
