#ifndef COLOR_P08_h
#define COLOR_P08_h

/*!
 	@file
 	@brief	PsNZ킷NXS
\n			WrbgCfbNX Ver.
 */
#include"../../Setup/CompileMode.h"
#include"../../Auxiliary/Macro.h"
#include"../../Auxiliary/Debug/CAssert.h"
#include"COLOR_A08R08G08B08I.h"
#include"COLOR_X08R08G08B08I.h"
#include<vector>

namespace Maid
{
	/*!
	 	@brief	WrbgCfbNXsNZ
	\n			pbg ev[gĂ܂
	 */
	template <class CLUTCOLOR>
	class COLOR_P08
	{
	public:

		//!	pbgz
//		typedef MySTL::vector<CLUTCOLOR> CLUT;

		COLOR_P08(){}	//!<	RXgN^
		COLOR_P08( unt08 a, unt08 r, unt08 g, unt08 b ){ SetARGB( a, r, g, b ); }	//!<	RXgN^
		template <class COLOR>
		COLOR_P08( const COLOR& Col ){  SetARGB( Col.GetA(), Col.GetR(), Col.GetG(), Col.GetB() );  }	//!<	RXgN^

		unt08 GetA() const	{ return GetSrc().GetA();	}	//!<	At@̎擾
		unt08 GetR() const	{ return GetSrc().GetR();	}	//!<	Ԑ̎擾
		unt08 GetG() const	{ return GetSrc().GetG();	}	//!<	ΐ̎擾
		unt08 GetB() const	{ return GetSrc().GetB();	}	//!<	̎擾

		operator unt32() const { return GetSrc(); }	//!<	ꊇϊ

		void SetA( unt08 a )	{/*΂炭̊ԃpX*/DEN_ASSERT( true, "ł" );}	//!<	At@̐ݒ
		void SetR( unt08 r )	{/*΂炭̊ԃpX*/DEN_ASSERT( true, "ł" );}	//!<	Ԑ̐ݒ
		void SetG( unt08 g )	{/*΂炭̊ԃpX*/DEN_ASSERT( true, "ł" );}	//!<	ΐ̐ݒ
		void SetB( unt08 b )	{/*΂炭̊ԃpX*/DEN_ASSERT( true, "ł" );}	//!<	̐ݒ

		void SetARGB( unt08 a, unt08 r, unt08 g, unt08 b )	//!<	ɐݒ
		{
			/*΂炭̊ԃpX*/
			MAID_ASSERT( true, "ł" );
		}

		//!	ႤsNZtH[}bgƂ̃Rs[
		template <class PIXEL>
		COLOR_P08& operator = (const PIXEL &src)
		{	/*΂炭̊ԃpX*/
			MAID_ASSERT( true, "ł" );
			return *this;
		}

		//!	sNZtH[}bgƂ̃Rs[
		COLOR_P08& operator = (const COLOR_P08& src)
		{	/*΂炭̊ԃpX*/
			MAID_ASSERT( true, "ł" );
			return *this;
		}

		//!	]pbg̐ݒ
		static void SetCLUTSrc( CLUTCOLOR* pPal ){ s_CLUTLIST_Src=pPal; }
		//!	]pbg̐ݒ
		static void SetCLUTDst( CLUTCOLOR* pPal ){ s_CLUTLIST_Dst=pPal; }
	private:

		//!	]pbg̎擾
		const CLUTCOLOR& GetSrc() const { return s_CLUTLIST_Src[m_Pixel]; }
		//!	]pbg̎擾
		const CLUTCOLOR& GetDst() const { return s_CLUTLIST_Dst[m_Pixel]; }
		unt08 m_Pixel;

	private:
		static CLUTCOLOR* s_CLUTLIST_Src;
		static CLUTCOLOR* s_CLUTLIST_Dst;
	};

	typedef COLOR_P08<COLOR_A08R08G08B08I>	COLOR_P08A08R08G08B08I;
	typedef COLOR_P08<COLOR_X08R08G08B08I>	COLOR_P08X08R08G08B08I;
}

#endif
