#ifndef COLOR_A08R08G08B08I_h
#define COLOR_A08R08G08B08I_h

/*!
 	@file
 	@brief	PsNZ킷NX
\n			ARGB8888 tH[}bg Ver.
 */
#include"../../Setup/CompileMode.h"
#include"../../Auxiliary/Macro.h"

namespace Maid
{
	/*!
	 	@class	COLOR_A08R08G08B08I COLOR_A08R08G08B08I.h
	 	@brief	At@tRQrbgsNZ
	 */
	class COLOR_A08R08G08B08I
	{
	public:
		COLOR_A08R08G08B08I(){}	//!<	RXgN^
		COLOR_A08R08G08B08I( unt08 a, unt08 r, unt08 g, unt08 b ){ SetARGB( a, r, g, b ); }	//!<	RXgN^
		template <class COLOR>
		COLOR_A08R08G08B08I( const COLOR& Col ){  SetARGB( Col.GetA(), Col.GetR(), Col.GetG(), Col.GetB() );  }	//!<	RXgN^


		unt08 GetA() const	{ return m_Alpha;	}	//!<	At@̎擾
		unt08 GetR() const	{ return m_Red;		}	//!<	Ԑ̎擾
		unt08 GetG() const	{ return m_Green;	}	//!<	ΐ̎擾
		unt08 GetB() const	{ return m_Blue;	}	//!<	̎擾

		operator unt32() const { return *((unt32*)&m_Blue); }	//!<	ꊇϊ

		void SetA( unt08 a )	{ m_Alpha = a;	}	//!<	At@̐ݒ
		void SetR( unt08 r )	{ m_Red   = r;	}	//!<	Ԑ̐ݒ
		void SetG( unt08 g )	{ m_Green = g;	}	//!<	ΐ̐ݒ
		void SetB( unt08 b )	{ m_Blue  = b;	}	//!<	̐ݒ

		void SetARGB( unt08 a, unt08 r, unt08 g, unt08 b )	//!<	ɐݒ
		{
			SetA( a );
			SetR( r );
			SetG( g );
			SetB( b );
		}

		//!	ႤsNZtH[}bgƂ̃Rs[
		template <class PIXEL>
		COLOR_A08R08G08B08I& operator = (const PIXEL &src)
		{
			SetARGB(src.GetA(),src.GetR(),src.GetG(),src.GetB());
			return *this;
		}

		//!	sNZtH[}bgƂ̃Rs[
		COLOR_A08R08G08B08I& operator = (const COLOR_A08R08G08B08I& src)
		{
			*(unt32*)(&m_Blue) = *(unt32*)(&src.m_Blue);
			return *this;
		}

	private:
		unt08 m_Blue;
		unt08 m_Green;
		unt08 m_Red;
		unt08 m_Alpha;
	};
}

#endif
