#include"CVertexShaderDefault.h"
#include"../Auxiliary/CString.h"
#include"../Auxiliary/Debug/CAssert.h"

#include"CGraphic.h"

namespace Maid
{

	ReferenceCount<mstring>	CVertexShaderDefault::s_Cache;

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! RXgN^
/*!
 */
CVertexShaderDefault::CVertexShaderDefault()
{
}

CVertexShaderDefault::CVertexShaderDefault( const CVertexShaderDefault& rha )
{
	const mstring id = rha.m_CodeName;

	if( !id.empty() )
	{
		m_CodeName = id;
		s_Cache.Add(id);
	}
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! fXgN^
/*!
 */
CVertexShaderDefault::~CVertexShaderDefault()
{
	Delete();
}



/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! CuŗpӂĂVF[_[쐬
/*!
	@param	name	[i ]	쐬VF[_[
 */
void CVertexShaderDefault::Create( VERTEXSHADERNAME::NAME name )
{
	Delete();

	const mstring codename = VERTEXSHADERNAME::GeneratDefault( name );

	if( s_Cache.Add(codename) )
	{
		GlobalPointer<CGraphic>::Get()->RegistVertexShaderDefault( codename );
	}

	m_CodeName = codename;
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! VF[_[j
/*!
 */
void CVertexShaderDefault::Delete()
{
	if( m_CodeName.empty() ) { return ; }

	if( s_Cache.Del(m_CodeName) )
	{
		GlobalPointer<CGraphic>::Get()->DeleteVertexShader( m_CodeName );
	}

	m_CodeName.clear();
}


mstring CVertexShaderDefault::GetID() const
{
	MAID_ASSERT( m_CodeName.empty(), "܂ǂݍł܂" );
	return m_CodeName;
}

CVertexShaderDefault& CVertexShaderDefault::operator = ( const CVertexShaderDefault& rha )
{
	Delete();

	const mstring id = rha.m_CodeName;

	if( !id.empty() )
	{
		m_CodeName = id;
		s_Cache.Add(id);
	}

	return *this;
}

}