#include"CVertexDeclarationDefault.h"
#include"CGraphic.h"


namespace Maid
{
	ReferenceCount<mstring>	CVertexDeclarationDefault::s_Cache;

CVertexDeclarationDefault::CVertexDeclarationDefault()
{

}

CVertexDeclarationDefault::CVertexDeclarationDefault(const CVertexDeclarationDefault& rha)
{
	const mstring id = rha.m_ID;

	if( !id.empty() )
	{
		m_ID = id;
		s_Cache.Add(id);
	}
}

CVertexDeclarationDefault::~CVertexDeclarationDefault()
{
	Delete();
}

mstring CVertexDeclarationDefault::GetID() const
{
	return m_ID;
}

void CVertexDeclarationDefault::Create( VERTEXDECLARATIONNAME::NAME name )
{
	Delete();

	const mstring id = VERTEXDECLARATIONNAME::GeneratDefault( name );

	if( s_Cache.Add(id) )
	{
		GlobalPointer<CGraphic>::Get()->RegistVertexDeclarationDefault( id );
	}

	m_ID = id;
}

void CVertexDeclarationDefault::Delete()
{
	if( m_ID.empty() ) { return ; }

	if( s_Cache.Del(m_ID) )
	{
		GlobalPointer<CGraphic>::Get()->DeleteVertexDeclaration( m_ID );
	}

	m_ID.clear();
}

CVertexDeclarationDefault& CVertexDeclarationDefault::operator = ( const CVertexDeclarationDefault& rha )
{
	Delete();

	const mstring id = rha.m_ID;

	if( !id.empty() )
	{
		m_ID = id;
		s_Cache.Add(id);
	}

	return *this;
}

}

