#ifndef CResourceNameGenerator_h
#define CResourceNameGenerator_h

#include"../Setup/CompileMode.h"
#include"../Auxiliary/mstring.h"

namespace Maid
{
	namespace TEXTURENAME
	{
		mstring GeneratRenderTarget( int id );
		mstring GeneratFont( int id );
		mstring GeneratFile( const mstring& name );
	}

	namespace SURFACENAME
	{
		mstring GeneratRT( int id );
	}

	namespace VERTEXNAME
	{
		mstring GeneratMemory( int id );
		mstring GeneratFile( const mstring& name );
	}

	namespace INDEXNAME
	{
		mstring GeneratMemory( int id );
		mstring GeneratFile( const mstring& name );
	}

	namespace VERTEXSHADERNAME
	{
		enum NAME
		{
			FILE,	//!<	t@Cɂ

			RHWCOLOR,	//!<	ϊςݒ_A_F𗬂
			SPRITE,		//!<	ϊςݒ_A_FAeNX`P𗬂

			COLOR3D,	//!<	Rc_A_F𗬂
			SPRITE3D,	//!<	Rc_A_FAeNX`P𗬂
			SPRITE3DMASK,	//!<	Rc_A_FAeNX`Q𗬂

			MODEL_COLOR,	//!<	Rc_A_F̓}eAifpj
			MODEL_TEXTURE,	//!<	Rc_AeNX`tuifpj

			MODELTONE_COLOR,	//!<	Rc_A_F̓}eAigD[fpj
			MODELTONE_TEXTURE,	//!<	Rc_AeNX`tuigD[fpj

			MODELTONE_LINE,		//!<	֊sigD[fpj
		};

		mstring GeneratDefault( NAME name );
		mstring GeneratFile( const mstring& name );
	}

	namespace VERTEXDECLARATIONNAME
	{
		enum NAME
		{
			XYZ0NORMAL1,		//!<	xyzstream0, normal1
			XYZ0NORMAL1TEX2,	//!<	xyzstream0, normal1 TexUV2
		};

		mstring GeneratDefault( NAME name );
	}

	namespace PIXELSHADERNAME
	{
		enum NAME
		{
			FILE,	//!<	t@Cɂ

			VERTEXCOLOR_NORMAL,	//!<	_F݂̂ŕʂɕ`
			VERTEXCOLOR_ADD,	//!<	_F݂̂ŉZ`
			VERTEXCOLOR_SUB,	//!<	_F݂̂ŌZ`
			VERTEXCOLOR_MUL,	//!<	_F݂̂ŏZ`
			VERTEXCOLOR_REVERSE,//!<	_F݂̂Ŕ]`
			VERTEXCOLOR_MAX,	//!<	_F݂̂łl`w`

			SPRITE_NORMAL,	//!<	eNX`ƒ_F̏Zŕʂɕ`
			SPRITE_ADD,		//!<	eNX`ƒ_F̏ZŉZ`
			SPRITE_SUB,		//!<	eNX`ƒ_F̏ZŌZ`
			SPRITE_MUL,		//!<	eNX`ƒ_F̏ZŏZ`
			SPRITE_REVERSE,	//!<	eNX`ƒ_F̏ZŔ]`
			SPRITE_MAX,		//!<	eNX`ƒ_F̏Złl`w`

			SPRITE_NORMAL_VCADD,	//!<	eNX`ƒ_F̉Zŕʂɕ`
			SPRITE_NORMAL_VCSUB,	//!<	eNX`ƒ_F̌Zŕʂɕ`

			FONT_NORMAL,	//!<	eLXg`p

			MODEL_COLOR,	//!<	_F݂̂ŕ`
			MODEL_TEXTURE,	//!<	eNX`F݂̂ŕ` At@͒_FeNX`

			MODELTONE_COLOR,	//!<	_F݂̂ŕ`igD[fpj
			MODELTONE_TEXTURE,	//!<	eNX`F݂̂ŕ` At@͒_FeNX`igD[fpj

			MODELTONE_LINE,		//!<	֊sigD[fpj

			SPRITE_MASK_NORMAL_ADD,	//!<	eNX`ƒ_F̏ZŃ}XNeNX`̃At@ŕ`
			SPRITE_MASK_NORMAL_SUB,	//!<	eNX`ƒ_F̏ZŃ}XNeNX`̃At@ŕ`
		};

		mstring GeneratDefault( NAME name );
		mstring GeneratFile( const mstring& name );
	}

}

#endif