#include"CMouseCursor.h"
#include"../Auxiliary/Debug/CAssert.h"

#include"../Auxiliary/CString.h"


namespace Maid
{

/*!
 *	\class	CMouseCursor CMouseCursor.h
 *	\brief	}EXJ[\
\n			}EXJ[\̕\AEBhEOɏoƂɃVXeJ[\̕\
\n			Ȃǂs܂B
\n			J[\̓XvCgAj[Vf[^𗘗p܂
 */

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! RXgN^
/*!
 */
CMouseCursor::CMouseCursor()
{

}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! t[̏
/*!
 */
void CMouseCursor::Update()
{
	m_Cursor.CountInc();


}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! t[̕`
/*!
 *	\param	Render	[i ]	_
 */
void CMouseCursor::OnDraw( CGraphic& Render, const CMouse& mouse )
{
	if( m_CursorStack.top()!=-1 && mouse.IsClipIn() )
	{
		SPRITE& data = m_Cursor.GetNowSprite();

		Render.BltSprite( POINT2DI(mouse.GetX(),mouse.GetY()), data );
	}
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! }EXJ[\̓ǂݍ
/*!
 *	\param	FileName	[i ]	VgXvCgt@C
 */
void CMouseCursor::LoadCursor( const mstring& FileName )
{
	StackReset();
	m_Cursor.Load( FileName );
	PushCursor(0);
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! }EXJ[\̕ύX
/*!
 *	\param	No	[i ]	VJ[\ԍ(-1Ŕ\܂)
 */
void CMouseCursor::ChangeCursor( int No )
{
	MAID_ASSERT( No!=-1 && No<0, MAIDTEXT("w肷ꍇ-1w肷邱 ") << No );
	if( No!=-1 )
	{
		m_Cursor.ChangePattern( No );
	}
	m_CursorStack.top() = No;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ݂̃J[\p^[ԍ擾
/*!
 *	\return ݂̔ԍ
 */
unt CMouseCursor::GetNowPatern() const
{
	return m_CursorStack.top();
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! }EXAj[VH
/*!
 */
bool CMouseCursor::IsAnimEnd() const
{
	return m_Cursor.IsEnd();
}

bool CMouseCursor::IsNowLoading()
{
	return m_Cursor.IsNowLoading();
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! J[\ꎞIɕύX
/*!
 *	̊֐ŃJ[\ύXꍇAPopCursor Ōɖ߂Ƃł܂
 *
 *	\param	No [i ]	VJ[\(-1Ŕ\܂)
 */
void CMouseCursor::PushCursor( int No )
{
	m_CursorStack.push( No );
	ChangeCursor( No );
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! PushCursor ŕύXĂJ[\ɖ߂܂
/*!
 */
void CMouseCursor::PopCursor()
{
	m_CursorStack.pop();
	if( !m_CursorStack.empty() )
	{
		const int no = m_CursorStack.top();
		ChangeCursor( no );
	}
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! PushCursor, PopCursor ŎgpĂX^bNɂ
/*!
 */
void CMouseCursor::StackReset()
{
	m_CursorStack = MySTL::stack<int>();
}

}
